/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import ru.tinkoff.kora.json.common.JsonReader;
import ru.tinkoff.kora.json.common.JsonWriter;

public class UuidJsonCodec
implements JsonReader<UUID>,
JsonWriter<UUID> {
    static final char[] HEX_CHARS;
    static final int[] HEX_DIGITS;

    @Override
    public void write(JsonGenerator gen, @Nullable UUID object) throws IOException {
        if (object == null) {
            gen.writeNull();
            return;
        }
        char[] ch = new char[36];
        long msb = object.getMostSignificantBits();
        UuidJsonCodec._appendInt((int)(msb >> 32), ch, 0);
        ch[8] = 45;
        int i = (int)msb;
        UuidJsonCodec._appendShort(i >>> 16, ch, 9);
        ch[13] = 45;
        UuidJsonCodec._appendShort(i, ch, 14);
        ch[18] = 45;
        long lsb = object.getLeastSignificantBits();
        UuidJsonCodec._appendShort((int)(lsb >>> 48), ch, 19);
        ch[23] = 45;
        UuidJsonCodec._appendShort((int)(lsb >>> 32), ch, 24);
        UuidJsonCodec._appendInt((int)lsb, ch, 28);
        gen.writeString(ch, 0, 36);
    }

    @Override
    @Nullable
    public UUID read(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        String id = parser.getValueAsString();
        if (id.length() != 36) {
            if (id.length() == 24) {
                byte[] stuff = Base64Variants.getDefaultVariant().decode(id);
                return this._fromBytes(stuff, parser);
            }
            return this._badFormat(id, parser);
        }
        if (id.charAt(8) != '-' || id.charAt(13) != '-' || id.charAt(18) != '-' || id.charAt(23) != '-') {
            this._badFormat(id, parser);
        }
        long l1 = this.intFromChars(id, 0, parser);
        long l2 = (long)this.shortFromChars(id, 9, parser) << 16;
        long hi = (l1 <<= 32) + (l2 |= (long)this.shortFromChars(id, 14, parser));
        int i1 = this.shortFromChars(id, 19, parser) << 16 | this.shortFromChars(id, 24, parser);
        l1 = i1;
        l2 = this.intFromChars(id, 28, parser);
        l2 = l2 << 32 >>> 32;
        long lo = (l1 <<= 32) | l2;
        return new UUID(hi, lo);
    }

    private static void _appendInt(int bits, char[] ch, int offset) {
        UuidJsonCodec._appendShort(bits >> 16, ch, offset);
        UuidJsonCodec._appendShort(bits, ch, offset + 4);
    }

    private static void _appendShort(int bits, char[] ch, int offset) {
        ch[offset] = HEX_CHARS[bits >> 12 & 0xF];
        ch[++offset] = HEX_CHARS[bits >> 8 & 0xF];
        ch[++offset] = HEX_CHARS[bits >> 4 & 0xF];
        ch[++offset] = HEX_CHARS[bits & 0xF];
    }

    private UUID _badFormat(String id, JsonParser parser) throws JsonParseException {
        throw new JsonParseException(parser, "UUID has to be represented by standard 36-char representation, got '%s'".formatted(id));
    }

    private int intFromChars(String str, int index, JsonParser ctxt) throws JsonParseException {
        return (this.byteFromChars(str, index, ctxt) << 24) + (this.byteFromChars(str, index + 2, ctxt) << 16) + (this.byteFromChars(str, index + 4, ctxt) << 8) + this.byteFromChars(str, index + 6, ctxt);
    }

    private int shortFromChars(String str, int index, JsonParser ctxt) throws JsonParseException {
        return (this.byteFromChars(str, index, ctxt) << 8) + this.byteFromChars(str, index + 2, ctxt);
    }

    private int byteFromChars(String str, int index, JsonParser ctxt) throws JsonParseException {
        int hex;
        char c1 = str.charAt(index);
        char c2 = str.charAt(index + 1);
        if (c1 <= '\u007f' && c2 <= '\u007f' && (hex = HEX_DIGITS[c1] << 4 | HEX_DIGITS[c2]) >= 0) {
            return hex;
        }
        if (c1 > '\u007f' || HEX_DIGITS[c1] < 0) {
            return this._badChar(str, index, ctxt, c1);
        }
        return this._badChar(str, index + 1, ctxt, c2);
    }

    private int _badChar(String uuidStr, int index, JsonParser ctxt, char c) throws JsonParseException {
        throw new JsonParseException(ctxt, String.format("Non-hex character '%c' (value 0x%s), not valid for UUID String (%s)", Character.valueOf(c), Integer.toHexString(c), uuidStr));
    }

    private UUID _fromBytes(byte[] bytes, JsonParser ctxt) throws JsonParseException {
        if (bytes.length != 16) {
            throw new JsonParseException(ctxt, "Can only construct UUIDs from byte[16]; got " + bytes.length + " bytes");
        }
        return new UUID(UuidJsonCodec._long(bytes, 0), UuidJsonCodec._long(bytes, 8));
    }

    private static long _long(byte[] b, int offset) {
        long l1 = (long)UuidJsonCodec._int(b, offset) << 32;
        long l2 = UuidJsonCodec._int(b, offset + 4);
        l2 = l2 << 32 >>> 32;
        return l1 | l2;
    }

    private static int _int(byte[] b, int offset) {
        return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    static {
        int i;
        HEX_CHARS = "0123456789abcdef".toCharArray();
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (i = 0; i < 10; ++i) {
            UuidJsonCodec.HEX_DIGITS[48 + i] = i;
        }
        for (i = 0; i < 6; ++i) {
            UuidJsonCodec.HEX_DIGITS[97 + i] = 10 + i;
            UuidJsonCodec.HEX_DIGITS[65 + i] = 10 + i;
        }
    }
}

