/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import jakarta.annotation.Nullable;
import java.io.IOException;
import ru.tinkoff.kora.json.common.util.BufferingJsonParser;

public class DiscriminatorHelper {
    @Nullable
    public static String readStringDiscriminator(BufferingJsonParser parser, String fieldName) throws IOException {
        JsonToken token = parser.currentToken();
        SerializedString name = new SerializedString(fieldName);
        assert (token == JsonToken.START_OBJECT);
        while (!parser.nextFieldName((SerializableString)name)) {
            if (parser.currentToken() == JsonToken.END_OBJECT) {
                return null;
            }
            parser.skipChildren();
        }
        if (parser.nextToken() != JsonToken.VALUE_STRING) {
            throw new JsonParseException((JsonParser)parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        }
        return parser.getValueAsString();
    }
}

