/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import ru.tinkoff.kora.json.common.JsonWriter;
import ru.tinkoff.kora.json.common.RawJson;

public final class EnumJsonWriter<T extends Enum<T>, V>
implements JsonWriter<T> {
    private final RawJson[] values;

    public EnumJsonWriter(T[] values, Function<T, V> valueExtractor, JsonWriter<V> valueWriter) {
        this.values = new RawJson[values.length];
        for (int i = 0; i < values.length; ++i) {
            T enumValue = values[i];
            V value = valueExtractor.apply(enumValue);
            try {
                byte[] bytes = valueWriter.toByteArray(value);
                this.values[i] = new RawJson(bytes);
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void write(JsonGenerator gen, @Nullable T object) throws IOException {
        if (object == null) {
            gen.writeNull();
            return;
        }
        gen.writeRawValue((SerializableString)this.values[((Enum)object).ordinal()]);
    }
}

