/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ru.tinkoff.kora.json.common.RawJson;

public class JsonObjectCodec {
    public static Object parse(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token.isScalarValue()) {
            if (token == JsonToken.VALUE_TRUE) {
                return true;
            }
            if (token == JsonToken.VALUE_FALSE) {
                return false;
            }
            if (token == JsonToken.VALUE_STRING) {
                return parser.getText();
            }
            if (token == JsonToken.VALUE_NUMBER_INT) {
                return parser.getBigIntegerValue();
            }
            if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                return parser.getDoubleValue();
            }
            throw new JsonParseException(parser, "Expecting {VALUE_TRUE, VALUE_FALSE, VALUE_STRING, VALUE_NUMBER_INT, VALUE_NUMBER_FLOAT} token, got " + token);
        }
        if (token == JsonToken.START_OBJECT) {
            String fieldName;
            HashMap<String, Object> object = new HashMap<String, Object>();
            while ((fieldName = parser.nextFieldName()) != null) {
                parser.nextToken();
                Object value = JsonObjectCodec.parse(parser);
                object.put(fieldName, value);
            }
            return object;
        }
        if (token == JsonToken.START_ARRAY) {
            ArrayList<Object> object = new ArrayList<Object>();
            while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
                Object value = JsonObjectCodec.parse(parser);
                object.add(value);
            }
            return object;
        }
        throw new JsonParseException(parser, "Unexpected token " + token);
    }

    public static void write(JsonGenerator gen, @Nullable Object object) throws IOException {
        if (object == null) {
            gen.writeNull();
            return;
        }
        if (object instanceof String) {
            String str = (String)object;
            gen.writeString(str);
            return;
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            gen.writeNumber(i.intValue());
            return;
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            gen.writeBoolean(b.booleanValue());
            return;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            gen.writeNumber(l.longValue());
            return;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            gen.writeNumber(d.doubleValue());
            return;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            gen.writeNumber(f.floatValue());
            return;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            gen.writeNumber(bd);
            return;
        }
        if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            gen.writeNumber(bi);
            return;
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime dt = (OffsetDateTime)object;
            gen.writeString(dt.toString());
            return;
        }
        if (object instanceof LocalDate) {
            LocalDate date = (LocalDate)object;
            gen.writeString(date.toString());
            return;
        }
        if (object instanceof Enum) {
            Enum e = (Enum)object;
            gen.writeString(e.name());
            return;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            gen.writeBinary(bytes);
            return;
        }
        if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            gen.writeString(uuid.toString());
            return;
        }
        if (object instanceof RawJson) {
            RawJson rawJson = (RawJson)object;
            gen.writeRawValue((SerializableString)rawJson);
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            gen.writeStartObject((Object)map);
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String str = (String)key;
                    gen.writeFieldName(str);
                } else if (key instanceof SerializableString) {
                    SerializableString str = (SerializableString)key;
                    gen.writeFieldName(str);
                } else {
                    throw new JsonGenerationException("Maps key should be strings", gen);
                }
                Object value = entry.getValue();
                JsonObjectCodec.write(gen, value);
            }
            gen.writeEndObject();
            return;
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            gen.writeStartArray((Object)iterable);
            for (Object o : iterable) {
                JsonObjectCodec.write(gen, o);
            }
            gen.writeEndArray();
            return;
        }
        throw new IllegalStateException("Invalid type " + object.getClass() + ". Valid types are T: Integer, Long, String, Double, Float, Biginteger, BigDecimal, OffsetDateTime, LocalDateTime, Enum, byte[], RawJson, UUID, Map<String, T>, Iterable<T>");
    }
}

