/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import ru.tinkoff.kora.json.common.JsonCommonModule;

public interface JsonWriter<T> {
    public void write(JsonGenerator var1, @Nullable T var2) throws IOException;

    default public byte[] toByteArray(@Nullable T value) throws IOException {
        ByteArrayBuilder bb = new ByteArrayBuilder(JsonCommonModule.JSON_FACTORY._getBufferRecycler());
        try {
            byte[] byArray;
            block9: {
                JsonGenerator gen = JsonCommonModule.JSON_FACTORY.createGenerator((OutputStream)bb, JsonEncoding.UTF8);
                try {
                    gen.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
                    this.write(gen, value);
                    gen.flush();
                    byArray = bb.toByteArray();
                    if (gen == null) break block9;
                }
                catch (Throwable throwable) {
                    if (gen != null) {
                        try {
                            gen.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gen.close();
            }
            return byArray;
        }
        finally {
            bb.release();
        }
    }

    default public byte[] toByteArrayUnchecked(@Nullable T value) throws UncheckedIOException {
        try {
            return this.toByteArray(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public String toString(@Nullable T value) throws IOException {
        try (SegmentedStringWriter sw = new SegmentedStringWriter(JsonCommonModule.JSON_FACTORY._getBufferRecycler());){
            String string;
            block11: {
                JsonGenerator gen = JsonCommonModule.JSON_FACTORY.createGenerator((Writer)sw);
                try {
                    gen.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
                    this.write(gen, value);
                    gen.flush();
                    string = sw.getAndClear();
                    if (gen == null) break block11;
                }
                catch (Throwable throwable) {
                    if (gen != null) {
                        try {
                            gen.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gen.close();
            }
            return string;
        }
    }

    default public String toStringUnchecked(@Nullable T value) throws UncheckedIOException {
        try {
            return this.toString(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

