/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ru.tinkoff.kora.json.common.JsonReader;

public class ListJsonReader<T>
implements JsonReader<List<T>> {
    private final JsonReader<T> reader;

    public ListJsonReader(JsonReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public List<T> read(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_ARRAY) {
            throw new JsonParseException(parser, "Expecting START_ARRAY token, got " + token);
        }
        token = parser.nextToken();
        if (token == JsonToken.END_ARRAY) {
            return List.of();
        }
        ArrayList<T> result = new ArrayList<T>(16);
        while (token != JsonToken.END_ARRAY) {
            T element = this.reader.read(parser);
            result.add(element);
            token = parser.nextToken();
        }
        return result;
    }
}

