/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import ru.tinkoff.kora.json.common.JsonWriter;

public class ListJsonWriter<T>
implements JsonWriter<List<T>> {
    private final JsonWriter<T> writer;

    public ListJsonWriter(JsonWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public void write(JsonGenerator gen, @Nullable List<T> object) throws IOException {
        if (object == null) {
            gen.writeNull();
        } else {
            gen.writeStartArray(object, object.size());
            for (T element : object) {
                this.writer.write(gen, element);
            }
            gen.writeEndArray();
        }
    }
}

