/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Set;
import ru.tinkoff.kora.json.common.JsonWriter;

public class SetJsonWriter<T>
implements JsonWriter<Set<T>> {
    private final JsonWriter<T> writer;

    public SetJsonWriter(JsonWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public void write(JsonGenerator gen, @Nullable Set<T> object) throws IOException {
        if (object == null) {
            gen.writeNull();
        } else {
            gen.writeStartArray(object, object.size());
            for (T element : object) {
                this.writer.write(gen, element);
            }
            gen.writeEndArray();
        }
    }
}

