/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import ru.tinkoff.kora.json.common.JsonCommonModule;
import ru.tinkoff.kora.json.common.util.JsonSegment;
import ru.tinkoff.kora.json.common.util.JsonSegmentJsonParser;

public class BufferingJsonParser
extends ParserBase {
    private final ArrayList<JsonSegment> tokens = new ArrayList();
    private final JsonParser delegate;
    private int currentToken;

    public BufferingJsonParser(JsonParser delegate) throws IOException {
        super(new IOContext(JsonCommonModule.JSON_FACTORY._getBufferRecycler(), ContentReference.rawReference((Object)delegate), false), delegate.getFeatureMask());
        this.delegate = delegate;
        this._currToken = delegate.currentToken();
        this.tokens.add(this.data(this._currToken, this.delegate));
        this.currentToken = 1;
    }

    public JsonSegmentJsonParser reset() {
        this.currentToken = -1;
        JsonSegment data = this.tokens.get(0);
        this._currToken = data.token();
        this._textBuffer.resetWithShared(data.data(), 0, data.data().length);
        return new JsonSegmentJsonParser(this._ioContext, this._features, new ArrayList<JsonSegment>(this.tokens));
    }

    protected void _closeInput() {
    }

    public ObjectCodec getCodec() {
        return this.delegate.getCodec();
    }

    public void setCodec(ObjectCodec oc) {
        this.delegate.setCodec(oc);
    }

    private JsonSegment data(JsonToken token, JsonParser parser) throws IOException {
        char[] textCharacters = parser.getTextCharacters();
        int textOffset = parser.getTextOffset();
        int textLength = parser.getTextLength();
        boolean isNegative = !token.isNumeric() ? false : this.isCurrentNumberNegative(parser);
        return new JsonSegment(token, Arrays.copyOfRange(textCharacters, textOffset, textOffset + textLength), isNegative);
    }

    private boolean isCurrentNumberNegative(JsonParser parser) throws IOException {
        return switch (parser.getNumberType()) {
            default -> throw new IncompatibleClassChangeError();
            case JsonParser.NumberType.INT -> {
                if (parser.getIntValue() < 0) {
                    yield true;
                }
                yield false;
            }
            case JsonParser.NumberType.LONG -> {
                if (parser.getLongValue() < 0L) {
                    yield true;
                }
                yield false;
            }
            case JsonParser.NumberType.BIG_INTEGER -> {
                if (((BigInteger)parser.getNumberValue()).signum() < 0) {
                    yield true;
                }
                yield false;
            }
            case JsonParser.NumberType.FLOAT -> {
                if (parser.getFloatValue() < 0.0f) {
                    yield true;
                }
                yield false;
            }
            case JsonParser.NumberType.DOUBLE -> {
                if (parser.getDoubleValue() < 0.0) {
                    yield true;
                }
                yield false;
            }
            case JsonParser.NumberType.BIG_DECIMAL -> ((BigDecimal)parser.getNumberValue()).signum() < 0;
        };
    }

    public JsonToken nextToken() throws IOException {
        JsonToken nextToken;
        if (this.currentToken < 0) {
            --this.currentToken;
            JsonSegment data = this.currentData();
            if (data != null) {
                JsonToken nextToken2 = data.token();
                if (nextToken2 == JsonToken.FIELD_NAME) {
                    this._parsingContext.setCurrentName(new String(data.data()));
                }
                this._currToken = nextToken2;
                this._textBuffer.resetWithShared(data.data(), 0, data.data().length);
                return nextToken2;
            }
            JsonToken token = this.delegate.nextToken();
            if (token == JsonToken.FIELD_NAME) {
                this._parsingContext.setCurrentName(this.delegate.currentName());
            } else if (token.isNumeric()) {
                this._numTypesValid = 0;
                this._numberNegative = this.isCurrentNumberNegative(this.delegate);
            }
            this._textBuffer.resetWithShared(this.delegate.getTextCharacters(), this.delegate.getTextOffset(), this.delegate.getTextLength());
            this._currToken = token;
            return token;
        }
        if (this.currentToken >= this.tokens.size()) {
            JsonToken nextToken3 = this.delegate.nextToken();
            if (nextToken3 == null) {
                return null;
            }
            JsonSegment data = this.data(nextToken3, this.delegate);
            ++this.currentToken;
            this.tokens.add(data);
            this._currToken = nextToken3;
            if (nextToken3 == JsonToken.FIELD_NAME) {
                this._parsingContext.setCurrentName(new String(data.data()));
            }
            this._textBuffer.resetWithShared(data.data(), 0, data.data().length);
            this._currToken = nextToken3;
            return nextToken3;
        }
        ++this.currentToken;
        JsonSegment data = this.tokens.get(this.currentToken - 1);
        this._currToken = nextToken = data.token();
        if (nextToken == JsonToken.FIELD_NAME) {
            this._parsingContext.setCurrentName(new String(data.data()));
        }
        this._textBuffer.resetWithShared(data.data(), 0, data.data().length);
        this._currToken = nextToken;
        return nextToken;
    }

    @Nullable
    public JsonSegment currentData() {
        int number = Math.abs(this.currentToken);
        if (number > this.tokens.size()) {
            return null;
        }
        return this.tokens.get(number - 1);
    }

    public String getText() throws IOException {
        JsonSegment currentData = this.currentData();
        if (currentData == null) {
            return this.delegate.getText();
        }
        return new String(currentData.data());
    }

    public char[] getTextCharacters() throws IOException {
        JsonSegment currentData = this.currentData();
        if (currentData == null) {
            return this.delegate.getTextCharacters();
        }
        return currentData.data();
    }

    public int getTextLength() throws IOException {
        JsonSegment currentData = this.currentData();
        if (currentData == null) {
            return this.delegate.getTextLength();
        }
        return currentData.data().length;
    }

    public int getTextOffset() throws IOException {
        JsonSegment currentData = this.currentData();
        if (currentData == null) {
            return this.delegate.getTextOffset();
        }
        return 0;
    }
}

