/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common.util;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.util.List;
import ru.tinkoff.kora.json.common.util.JsonSegment;

public class JsonSegmentJsonParser
extends ParserBase {
    private final List<JsonSegment> segments;
    private int currentSegment = -1;

    public JsonSegmentJsonParser(IOContext context, int features, List<JsonSegment> segments) {
        super(context, features);
        this.segments = segments;
    }

    protected void _closeInput() throws IOException {
    }

    public ObjectCodec getCodec() {
        return null;
    }

    public void setCodec(ObjectCodec oc) {
    }

    public JsonToken nextToken() throws IOException {
        JsonToken token;
        ++this.currentSegment;
        if (this.currentSegment >= this.segments.size()) {
            return null;
        }
        JsonSegment segment = this.segments.get(this.currentSegment);
        this._currToken = token = segment.token();
        this._textBuffer.resetWithShared(segment.data(), 0, segment.data().length);
        if (token == JsonToken.FIELD_NAME) {
            this._parsingContext.setCurrentName(new String(segment.data()));
        } else if (token.isNumeric()) {
            this._numTypesValid = 0;
            this._numberNegative = segment.isNumberNegative();
            this._intLength = segment.data().length;
        }
        return token;
    }

    private JsonSegment current() {
        int currentSegment = this.currentSegment;
        if (currentSegment >= this.segments.size()) {
            return null;
        }
        return this.segments.get(currentSegment);
    }

    public String getText() throws IOException {
        JsonSegment segment = this.current();
        return new String(segment.data());
    }

    public char[] getTextCharacters() throws IOException {
        JsonSegment segment = this.current();
        return segment.data();
    }

    public int getTextLength() throws IOException {
        return this.current().data().length;
    }

    public int getTextOffset() throws IOException {
        return 0;
    }
}

