/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.http;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.flow.LazySingleSubscription;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.json.common.JsonWriter;
import ru.tinkoff.kora.json.module.JsonModule;

public final class JsonHttpBodyOutput<T>
implements HttpBodyOutput {
    private final JsonWriter<T> writer;
    private final Context context;
    @Nullable
    private final T value;

    public JsonHttpBodyOutput(JsonWriter<T> writer, Context context, @Nullable T value) {
        this.writer = writer;
        this.value = value;
        this.context = context;
    }

    public long contentLength() {
        return -1L;
    }

    public String contentType() {
        return "application/json";
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe((Flow.Subscription)new LazySingleSubscription(subscriber, this.context, () -> {
            byte[] resultBytes = this.writer.toByteArray(this.value);
            return ByteBuffer.wrap(resultBytes);
        }));
    }

    public void write(OutputStream os) throws IOException {
        try (JsonGenerator gen = JsonModule.JSON_FACTORY.createGenerator(os, JsonEncoding.UTF8);){
            this.writer.write(gen, this.value);
        }
    }

    public void close() throws IOException {
    }
}

