/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.http.client;

import java.io.IOException;
import java.io.InputStream;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.json.common.JsonReader;

public class JsonHttpClientResponseMapper<T>
implements HttpClientResponseMapper<T> {
    private final JsonReader<T> jsonReader;

    public JsonHttpClientResponseMapper(JsonReader<T> jsonReader) {
        this.jsonReader = jsonReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T apply(HttpClientResponse response) throws IOException {
        try (HttpBodyInput body = response.body();
             InputStream is = body.asInputStream();){
            if (is != null) {
                Object object = this.jsonReader.read(is);
                return (T)object;
            }
            byte[] bytes = (byte[])body.asArrayStage().toCompletableFuture().get();
            Object object = this.jsonReader.read(bytes);
            return (T)object;
        }
    }
}

