/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.http.client;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;
import ru.tinkoff.kora.json.common.JsonReader;

public class JsonReaderAsyncHttpClientResponseEntityMapper<T>
implements HttpClientResponseMapper<CompletionStage<HttpResponseEntity<T>>> {
    private final JsonReader<T> jsonReader;

    public JsonReaderAsyncHttpClientResponseEntityMapper(JsonReader<T> jsonReader) {
        this.jsonReader = jsonReader;
    }

    @Nullable
    public CompletionStage<HttpResponseEntity<T>> apply(@Nonnull HttpClientResponse response) throws IOException, HttpClientDecoderException {
        return FlowUtils.toByteArrayFuture((Flow.Publisher)response.body()).thenApply(bytes -> {
            try {
                Object value = this.jsonReader.read(bytes);
                return HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), (Object)value);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

