/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.http.client;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import ru.tinkoff.kora.http.client.common.HttpClientDecoderException;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponse;
import ru.tinkoff.kora.http.client.common.response.HttpClientResponseMapper;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;
import ru.tinkoff.kora.json.common.JsonReader;

public final class JsonReaderHttpClientResponseEntityMapper<T>
implements HttpClientResponseMapper<HttpResponseEntity<T>> {
    private final JsonReader<T> jsonReader;

    public JsonReaderHttpClientResponseEntityMapper(JsonReader<T> jsonReader) {
        this.jsonReader = jsonReader;
    }

    public HttpResponseEntity<T> apply(@Nonnull HttpClientResponse response) throws IOException, HttpClientDecoderException {
        try (HttpBodyInput body = response.body();){
            InputStream is = body.asInputStream();
            if (is != null) {
                Object value = this.jsonReader.read(is);
                HttpResponseEntity httpResponseEntity = HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), (Object)value);
                return httpResponseEntity;
            }
            byte[] bytes = (byte[])body.asArrayStage().toCompletableFuture().get();
            Object value = this.jsonReader.read(bytes);
            HttpResponseEntity httpResponseEntity = HttpResponseEntity.of((int)response.code(), (MutableHttpHeaders)response.headers().toMutable(), (Object)value);
            return httpResponseEntity;
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

