/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.ByteBufferInputStream;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;
import ru.tinkoff.kora.json.common.JsonReader;

public final class JsonReaderAsyncHttpServerRequestMapper<T>
implements HttpServerRequestMapper<CompletionStage<T>> {
    private final JsonReader<T> reader;

    public JsonReaderAsyncHttpServerRequestMapper(JsonReader<T> reader) {
        this.reader = reader;
    }

    public CompletionStage<T> apply(HttpServerRequest request) throws IOException {
        HttpBodyInput body = request.body();
        ByteBuffer fullContent = body.getFullContentIfAvailable();
        if (fullContent != null) {
            try (HttpBodyInput httpBodyInput = body;){
                if (fullContent.hasArray()) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(this.reader.read(fullContent.array(), fullContent.arrayOffset(), fullContent.remaining()));
                    return completableFuture;
                }
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(this.reader.read((InputStream)new ByteBufferInputStream(fullContent)));
                return completableFuture;
            }
        }
        return FlowUtils.toByteArrayFuture((Flow.Publisher)request.body()).thenApply(bytes -> {
            try {
                return this.reader.read(bytes);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

