/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.module.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import ru.tinkoff.kora.common.util.ByteBufferInputStream;
import ru.tinkoff.kora.json.common.JsonReader;

public final class JsonKafkaDeserializer<T>
implements Deserializer<T> {
    private final JsonReader<T> reader;

    public JsonKafkaDeserializer(JsonReader<T> reader) {
        this.reader = reader;
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (T)this.reader.read(data);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to deserialize from json", (Throwable)e);
        }
    }

    public T deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.hasArray()) {
            try {
                return (T)this.reader.read(data.array(), data.arrayOffset() + data.position(), data.remaining());
            }
            catch (IOException e) {
                throw new SerializationException("Unable to deserialize from json", (Throwable)e);
            }
        }
        int position = data.position();
        try {
            Object object;
            ByteBufferInputStream is = new ByteBufferInputStream(data);
            try {
                object = this.reader.read((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializationException("Unable to deserialize from json", (Throwable)e);
                }
            }
            is.close();
            return (T)object;
        }
        finally {
            data.position(position);
        }
    }
}

