/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.KafkaConsumerHandlerGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaUtils;

public class KafkaConsumerContainerGenerator {
    public MethodSpec generate(ExecutableElement executableElement, KafkaConsumerHandlerGenerator.HandlerMethod handlerMethod, List<ConsumerParameter> parameters) {
        String tagName = KafkaUtils.prepareConsumerTagName(executableElement);
        CodeBlock tagsBlock = CodeBlock.of((String)"$L.class", (Object[])new Object[]{tagName});
        AnnotationSpec tagAnnotation = AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", tagsBlock).build();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)KafkaUtils.prepareMethodName(executableElement, "Container")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(CommonClassNames.root).addAnnotation(tagAnnotation).returns((TypeName)CommonClassNames.lifecycle);
        ParameterizedTypeName handlerTypeName = (ParameterizedTypeName)handlerMethod.method().returnType;
        ParameterSpec configParameter = ParameterSpec.builder((TypeName)KafkaClassNames.kafkaConsumerConfig, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(tagAnnotation).build();
        methodBuilder.addParameter(configParameter);
        ParameterSpec handlerParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.valueOf, (TypeName[])new TypeName[]{handlerTypeName}), (String)"handler", (Modifier[])new Modifier[0]).addAnnotation(tagAnnotation).build();
        methodBuilder.addParameter(handlerParameter);
        ParameterSpec.Builder keyDeserializer = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.deserializer, (TypeName[])new TypeName[]{handlerMethod.keyType()}), (String)"keyDeserializer", (Modifier[])new Modifier[0]);
        if (!handlerMethod.keyTag().isEmpty()) {
            AnnotationSpec keyTag = TagUtils.makeAnnotationSpec(handlerMethod.keyTag());
            keyDeserializer.addAnnotation(keyTag);
        }
        ParameterSpec.Builder valueDeserializer = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.deserializer, (TypeName[])new TypeName[]{handlerMethod.valueType()}), (String)"valueDeserializer", (Modifier[])new Modifier[0]);
        if (!handlerMethod.valueTag().isEmpty()) {
            AnnotationSpec valueTag = TagUtils.makeAnnotationSpec(handlerMethod.valueTag());
            valueDeserializer.addAnnotation(valueTag);
        }
        methodBuilder.addParameter(keyDeserializer.build());
        methodBuilder.addParameter(valueDeserializer.build());
        methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.kafkaConsumerTelemetryFactory, (TypeName[])new TypeName[]{handlerMethod.keyType(), handlerMethod.valueType()}), "telemetryFactory", new Modifier[0]);
        methodBuilder.addStatement("var telemetry = telemetryFactory.get(config.driverProperties(), config.telemetry())", new Object[0]);
        Optional<ConsumerParameter.Consumer> consumerParameter = parameters.stream().filter(r -> r instanceof ConsumerParameter.Consumer).map(ConsumerParameter.Consumer.class::cast).findFirst();
        if (handlerTypeName.rawType.equals((Object)KafkaClassNames.recordHandler)) {
            methodBuilder.addCode("var wrappedHandler = $T.wrapHandlerRecord(telemetry, $L, handler);\n", new Object[]{KafkaClassNames.handlerWrapper, consumerParameter.isEmpty()});
        } else {
            methodBuilder.addCode("var wrappedHandler = $T.wrapHandlerRecords(telemetry, $L, handler);\n", new Object[]{KafkaClassNames.handlerWrapper, consumerParameter.isEmpty()});
        }
        methodBuilder.addCode("if (config.driverProperties().getProperty($T.GROUP_ID_CONFIG) == null) {$>\n", new Object[]{KafkaClassNames.commonClientConfigs});
        methodBuilder.beginControlFlow("if (config.topics() == null || config.topics().size() != 1)", new Object[0]);
        methodBuilder.addStatement("throw new java.lang.IllegalArgumentException($S + config.topics())", new Object[]{"@KafkaListener require to specify 1 topic to subscribe when groupId is null, but received: "});
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return new $T<>(config, config.topics().get(0), keyDeserializer, valueDeserializer, telemetry, wrappedHandler);", new Object[]{KafkaClassNames.kafkaAssignConsumerContainer});
        methodBuilder.addCode("$<\n} else {$>\n", new Object[0]);
        methodBuilder.addCode("return new $T<>(config, keyDeserializer, valueDeserializer, wrappedHandler);", new Object[]{KafkaClassNames.kafkaSubscribeConsumerContainer});
        methodBuilder.addCode("$<\n}\n", new Object[0]);
        return methodBuilder.build();
    }
}

