/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.consumer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaUtils;

public class KafkaConsumerHandlerGenerator {
    public HandlerMethod generate(ExecutableElement executableElement, List<ConsumerParameter> parameters) {
        TypeElement controller = (TypeElement)executableElement.getEnclosingElement();
        String methodName = KafkaUtils.prepareMethodName(executableElement, "Handler");
        String tagName = KafkaUtils.prepareConsumerTagName(executableElement);
        CodeBlock tagsBlock = CodeBlock.of((String)"$L.class", (Object[])new Object[]{tagName});
        AnnotationSpec tag = AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", tagsBlock).build();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter(TypeName.get((TypeMirror)controller.asType()), "controller", new Modifier[0]).addAnnotation(tag).returns((TypeName)CommonClassNames.lifecycle);
        boolean hasRecords = parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.Records);
        boolean hasRecord = parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.Record);
        if (hasRecords) {
            return this.generateRecords(executableElement, parameters, methodBuilder);
        }
        if (hasRecord) {
            return this.generateRecord(executableElement, parameters, methodBuilder);
        }
        return this.generateKeyValue(executableElement, parameters, methodBuilder);
    }

    private HandlerMethod generateRecord(ExecutableElement executableElement, List<ConsumerParameter> parameters, MethodSpec.Builder methodBuilder) {
        WildcardType w;
        CodeBlock.Builder b = CodeBlock.builder();
        ConsumerParameter.Record recordParameter = parameters.stream().filter(p -> p instanceof ConsumerParameter.Record).map(ConsumerParameter.Record.class::cast).findFirst().orElseThrow();
        DeclaredType recordType = (DeclaredType)recordParameter.element().asType();
        TypeMirror keyTypeMirror = recordType.getTypeArguments().get(0);
        if ((keyTypeMirror instanceof WildcardType || keyTypeMirror instanceof IntersectionType || keyTypeMirror instanceof UnionType) && (!(keyTypeMirror instanceof WildcardType) || (w = (WildcardType)keyTypeMirror).getSuperBound() != null || w.getExtendsBound() != null)) {
            String message = "Kafka listener method has invalid key type %s".formatted(keyTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        TypeMirror valueTypeMirror = recordType.getTypeArguments().get(1);
        if (valueTypeMirror instanceof WildcardType || valueTypeMirror instanceof IntersectionType || valueTypeMirror instanceof UnionType) {
            String message = "Kafka listener method has invalid value type %s".formatted(valueTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        ArrayTypeName keyType = keyTypeMirror instanceof WildcardType ? ArrayTypeName.of((TypeName)TypeName.BYTE) : TypeName.get((TypeMirror)keyTypeMirror);
        TypeName valueType = TypeName.get((TypeMirror)valueTypeMirror);
        boolean catchesKeyException = parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.KeyDeserializationException || p instanceof ConsumerParameter.Exception);
        boolean catchesValueException = parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.ValueDeserializationException || p instanceof ConsumerParameter.Exception);
        methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.recordHandler, (TypeName[])new TypeName[]{keyType, valueType}));
        b.add("return (consumer, tctx, record) -> {$>\n", new Object[0]);
        if (catchesKeyException || catchesValueException) {
            if (catchesKeyException) {
                b.add("$T keyException = null;\n", new Object[]{KafkaClassNames.recordKeyDeserializationException});
            }
            if (catchesValueException) {
                b.add("$T valueException = null;\n", new Object[]{KafkaClassNames.recordValueDeserializationException});
            }
            b.add("try {$>\n", new Object[0]);
            if (catchesKeyException) {
                b.add("record.key();\n", new Object[0]);
            }
            if (catchesValueException) {
                b.add("record.value();\n", new Object[0]);
            }
            if (catchesKeyException) {
                b.add("$<\n} catch ($T e) {$>\n", new Object[]{KafkaClassNames.recordKeyDeserializationException});
                b.add("keyException = e;", new Object[0]);
            }
            if (catchesValueException) {
                b.add("$<\n} catch ($T e) {$>\n", new Object[]{KafkaClassNames.recordValueDeserializationException});
                b.add("valueException = e;", new Object[0]);
            }
            b.add("$<\n}\n", new Object[0]);
        }
        b.add("controller.$N(", new Object[]{executableElement.getSimpleName()});
        for (int i = 0; i < parameters.size(); ++i) {
            ConsumerParameter parameter;
            if (i > 0) {
                b.add(", ", new Object[0]);
            }
            if ((parameter = parameters.get(i)) instanceof ConsumerParameter.Consumer) {
                b.add("consumer", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Record) {
                b.add("record", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.KeyDeserializationException) {
                b.add("keyException", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.ValueDeserializationException) {
                b.add("valueException", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Exception) {
                b.add("keyException != null ? keyException : valueException", new Object[0]);
                continue;
            }
            throw new ProcessingErrorException("Record listener can't have parameter of type %s, only consumer, record, record key, record value, exception and record telemetry are allowed".formatted(parameter.element().asType()), (Element)parameter.element());
        }
        b.add(");", new Object[0]);
        b.add("$<\n};\n", new Object[0]);
        Set keyTag = TagUtils.parseTagValue((AnnotatedConstruct)keyTypeMirror);
        Set valueTag = TagUtils.parseTagValue((AnnotatedConstruct)valueTypeMirror);
        methodBuilder.addCode(b.build());
        return new HandlerMethod(methodBuilder.build(), (TypeName)keyType, keyTag, valueType, valueTag);
    }

    private HandlerMethod generateKeyValue(ExecutableElement executableElement, List<ConsumerParameter> parameters, MethodSpec.Builder methodBuilder) {
        TypeMirror keyTypeMirror;
        ConsumerParameter.Unknown keyParameter = null;
        ConsumerParameter.Unknown valueParameter = null;
        ConsumerParameter.Headers headersParameter = null;
        for (ConsumerParameter parameter : parameters) {
            ConsumerParameter.Headers headers;
            if (parameter instanceof ConsumerParameter.Unknown) {
                ConsumerParameter.Unknown u = (ConsumerParameter.Unknown)parameter;
                if (valueParameter == null) {
                    valueParameter = u;
                    continue;
                }
                if (keyParameter == null) {
                    keyParameter = valueParameter;
                    valueParameter = u;
                    continue;
                }
                String message = "Kafka listener method has unknown type parameter '%s'. Previous unknown type parameters are: '%s'(detected as key), '%s'(detected as value)".formatted(parameter.element().getSimpleName(), keyParameter.element().getSimpleName(), valueParameter.element().getSimpleName());
                throw new ProcessingErrorException(message, (Element)parameter.element());
            }
            if (!(parameter instanceof ConsumerParameter.Headers)) continue;
            headersParameter = headers = (ConsumerParameter.Headers)parameter;
        }
        if (valueParameter == null) {
            String message = "Kafka listener method should have one of ConsumerRecord, ConsumerRecords or non service type parameters";
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        TypeMirror typeMirror = keyTypeMirror = keyParameter == null ? null : keyParameter.element().asType();
        if (!(keyTypeMirror == null || keyTypeMirror instanceof DeclaredType || keyTypeMirror instanceof ArrayType || keyTypeMirror instanceof PrimitiveType)) {
            String message = "Kafka listener method has invalid key type %s".formatted(keyTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        TypeMirror valueTypeMirror = valueParameter.element().asType();
        if (!(valueTypeMirror instanceof DeclaredType || valueTypeMirror instanceof ArrayType || valueTypeMirror instanceof PrimitiveType)) {
            String message = "Kafka listener method has invalid value type %s".formatted(valueTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        ArrayTypeName keyType = keyTypeMirror == null || keyTypeMirror.toString().equals("java.lang.Object") ? ArrayTypeName.of((TypeName)TypeName.BYTE) : TypeName.get((TypeMirror)keyTypeMirror).box();
        TypeName valueType = TypeName.get((TypeMirror)valueTypeMirror).box();
        boolean catchesKeyException = keyParameter != null && parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.KeyDeserializationException || p instanceof ConsumerParameter.Exception);
        boolean catchesValueException = parameters.stream().anyMatch(p -> p instanceof ConsumerParameter.ValueDeserializationException || p instanceof ConsumerParameter.Exception);
        methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.recordHandler, (TypeName[])new TypeName[]{keyType, valueType}));
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("return (consumer, tctx, record) -> {$>\n", new Object[0]);
        if (catchesKeyException) {
            b.add("$T keyException = null;\n", new Object[]{KafkaClassNames.recordKeyDeserializationException});
        }
        if (catchesValueException) {
            b.add("$T valueException = null;\n", new Object[]{KafkaClassNames.recordValueDeserializationException});
        }
        if (keyParameter != null) {
            b.add("$T key = null;\n", new Object[]{keyType});
        }
        b.add("$T value = null;\n", new Object[]{valueType});
        if (headersParameter != null) {
            b.add("var headers = record.headers();\n", new Object[0]);
        }
        if (catchesKeyException || catchesValueException) {
            b.add("try {$>\n", new Object[0]);
        }
        if (keyParameter != null) {
            b.add("key = record.key();\n", new Object[0]);
        }
        b.add("value = record.value();\n", new Object[0]);
        if (catchesKeyException) {
            b.add("$<\n} catch ($T e) {$>\n", new Object[]{KafkaClassNames.recordKeyDeserializationException});
            b.add("keyException = e;", new Object[0]);
        }
        if (catchesValueException) {
            b.add("$<\n} catch ($T e) {$>\n", new Object[]{KafkaClassNames.recordValueDeserializationException});
            b.add("valueException = e;", new Object[0]);
        }
        if (catchesKeyException || catchesValueException) {
            b.add("$<\n}\n", new Object[0]);
        }
        b.add("controller.$N(", new Object[]{executableElement.getSimpleName()});
        boolean keySeen = false;
        for (int i = 0; i < parameters.size(); ++i) {
            ConsumerParameter parameter;
            if (i > 0) {
                b.add(", ", new Object[0]);
            }
            if ((parameter = parameters.get(i)) instanceof ConsumerParameter.Consumer) {
                b.add("consumer", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.KeyDeserializationException) {
                b.add("keyException", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.ValueDeserializationException) {
                b.add("valueException", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Exception) {
                if (keyParameter != null) {
                    b.add("keyException != null ? keyException : valueException", new Object[0]);
                    continue;
                }
                b.add("valueException", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Headers) {
                b.add("headers", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Unknown) {
                if (keyParameter == null || keySeen) {
                    b.add("value", new Object[0]);
                    continue;
                }
                keySeen = true;
                b.add("key", new Object[0]);
                continue;
            }
            throw new ProcessingErrorException("Record listener can't have parameter of type %s, only consumer, record, record key, record value, exception and record telemetry are allowed".formatted(parameter.element().asType()), (Element)parameter.element());
        }
        b.add(");", new Object[0]);
        b.add("$<\n};\n", new Object[0]);
        Set keyTag = keyParameter == null ? Set.of() : TagUtils.parseTagValue((AnnotatedConstruct)keyParameter.element());
        Set valueTag = TagUtils.parseTagValue((AnnotatedConstruct)valueParameter.element());
        methodBuilder.addCode(b.build());
        return new HandlerMethod(methodBuilder.build(), (TypeName)keyType, keyTag, valueType, valueTag);
    }

    private HandlerMethod generateRecords(ExecutableElement executableElement, List<ConsumerParameter> parameters, MethodSpec.Builder methodBuilder) {
        WildcardType w;
        WildcardType w2;
        ConsumerParameter.Records recordsParameter = parameters.stream().filter(r -> r instanceof ConsumerParameter.Records).map(ConsumerParameter.Records.class::cast).findFirst().orElseThrow();
        TypeMirror keyTypeMirror = recordsParameter.key();
        TypeMirror valueTypeMirror = recordsParameter.value();
        if ((keyTypeMirror instanceof WildcardType || keyTypeMirror instanceof IntersectionType || keyTypeMirror instanceof UnionType) && (!(keyTypeMirror instanceof WildcardType) || (w2 = (WildcardType)keyTypeMirror).getSuperBound() != null || w2.getExtendsBound() != null)) {
            String message = "Kafka listener method has invalid key type %s".formatted(keyTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        if (valueTypeMirror instanceof WildcardType || valueTypeMirror instanceof IntersectionType || valueTypeMirror instanceof UnionType) {
            String message = "Kafka listener method has invalid value type %s".formatted(valueTypeMirror);
            throw new ProcessingErrorException(message, (Element)executableElement);
        }
        TypeName keyType = keyTypeMirror instanceof WildcardType && (w = (WildcardType)keyTypeMirror).getSuperBound() == null && w.getExtendsBound() == null ? ArrayTypeName.of((TypeName)TypeName.BYTE) : TypeName.get((TypeMirror)keyTypeMirror);
        TypeName valueType = TypeName.get((TypeMirror)valueTypeMirror);
        methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.recordsHandler, (TypeName[])new TypeName[]{keyType, valueType}));
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("return (consumer, tctx, records) -> {$>\n", new Object[0]);
        b.add("controller.$N(", new Object[]{executableElement.getSimpleName()});
        for (int i = 0; i < parameters.size(); ++i) {
            ConsumerParameter parameter;
            if (i > 0) {
                b.add(", ", new Object[0]);
            }
            if ((parameter = parameters.get(i)) instanceof ConsumerParameter.Consumer) {
                b.add("consumer", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.RecordsTelemetry) {
                b.add("tctx", new Object[0]);
                continue;
            }
            if (parameter instanceof ConsumerParameter.Records) {
                b.add("records", new Object[0]);
                continue;
            }
            throw new ProcessingErrorException("Records listener can't have parameter of type %s, only consumer, records and records telemetry are allowed".formatted(parameter.element().asType()), (Element)parameter.element());
        }
        b.add(");", new Object[0]);
        b.add("$<\n};\n", new Object[0]);
        Set keyTag = TagUtils.parseTagValue((AnnotatedConstruct)keyTypeMirror);
        Set valueTag = TagUtils.parseTagValue((AnnotatedConstruct)valueTypeMirror);
        methodBuilder.addCode(b.build());
        return new HandlerMethod(methodBuilder.build(), keyType, keyTag, valueType, valueTag);
    }

    public record HandlerMethod(MethodSpec method, TypeName keyType, Set<String> keyTag, TypeName valueType, Set<String> valueTag) {
    }
}

