/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.producer;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherGenerator;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherTransactionalGenerator;

public class KafkaPublisherAnnotationProcessor
extends AbstractKoraProcessor {
    private TypeElement kafkaProducerAnnotationElement;
    private TypeElement aopProxyAnnotationElement;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.kafkaProducerAnnotationElement = this.elements.getTypeElement(KafkaClassNames.kafkaPublisherAnnotation.canonicalName());
        this.aopProxyAnnotationElement = this.elements.getTypeElement(CommonClassNames.aopProxy.canonicalName());
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(KafkaClassNames.kafkaPublisherAnnotation.canonicalName(), CommonClassNames.aopProxy.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        AnnotationMirror annotation;
        if (this.kafkaProducerAnnotationElement == null) {
            return false;
        }
        Set<? extends Element> producers = roundEnv.getElementsAnnotatedWith(this.kafkaProducerAnnotationElement);
        KafkaPublisherTransactionalGenerator publisherTransactionalGenerator = new KafkaPublisherTransactionalGenerator(this.types, this.elements, this.processingEnv);
        KafkaPublisherGenerator publisherGenerator = new KafkaPublisherGenerator(this.types, this.elements, this.processingEnv);
        List<AopProxy> aopProxies = this.getAopProxies(roundEnv);
        for (AopProxy aopProxy : aopProxies) {
            ArrayList<ExecutableElement> publishMethods = new ArrayList<ExecutableElement>();
            for (Element element : aopProxy.publisher().getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                publishMethods.add((ExecutableElement)element);
            }
            annotation = AnnotationUtils.findAnnotation((Element)aopProxy.publisher, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
            try {
                publisherGenerator.generatePublisherModule(aopProxy.publisher, publishMethods, annotation, aopProxy.proxy);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        for (Element element : producers) {
            try {
                TypeElement typeElement;
                if (!(element instanceof TypeElement) || (typeElement = (TypeElement)element).getKind() != ElementKind.INTERFACE) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                if (list.isEmpty()) {
                    ArrayList<ExecutableElement> publishMethods = new ArrayList<ExecutableElement>();
                    for (Element element2 : typeElement.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.METHOD || element2.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                        publishMethods.add((ExecutableElement)element2);
                    }
                    publisherGenerator.generateConfig(typeElement, publishMethods);
                    if (!CommonUtils.hasAopAnnotations((TypeElement)typeElement)) {
                        publisherGenerator.generatePublisherModule(typeElement, publishMethods, annotation, null);
                    }
                    publisherGenerator.generatePublisherImplementation(typeElement, publishMethods, annotation);
                    continue;
                }
                if (list.size() != 1) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                DeclaredType supertypeMirror = (DeclaredType)list.get(0);
                TypeName typeName = TypeName.get((TypeMirror)supertypeMirror);
                if (!(typeName instanceof ParameterizedTypeName)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
                    continue;
                }
                ParameterizedTypeName supertypeName = (ParameterizedTypeName)typeName;
                if (supertypeName.rawType.equals((Object)KafkaClassNames.transactionalPublisher)) {
                    DeclaredType declaredType = (DeclaredType)supertypeMirror.getTypeArguments().get(0);
                    TypeElement publisherTypeElement = (TypeElement)declaredType.asElement();
                    AnnotationMirror publisherAnnotation = AnnotationUtils.findAnnotation((Element)publisherTypeElement, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
                    if (publisherAnnotation == null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "TransactionalPublisher can only have argument types that annotated with @KafkaPublisher too", element);
                        continue;
                    }
                    ClassName publisherType = ClassName.get((TypeElement)publisherTypeElement);
                    publisherTransactionalGenerator.generatePublisherTransactionalModule(typeElement, publisherTypeElement, annotation);
                    publisherTransactionalGenerator.generatePublisherTransactionalImpl(typeElement, publisherType, publisherTypeElement);
                    continue;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@KafkaPublisher can be placed only on interfaces extending only TransactionalPublisher or none", element);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    private List<AopProxy> getAopProxies(RoundEnvironment roundEnv) {
        Set<? extends Element> proxies = roundEnv.getElementsAnnotatedWith(this.aopProxyAnnotationElement);
        ArrayList<AopProxy> list = new ArrayList<AopProxy>(proxies.size());
        block0: for (Element element : proxies) {
            TypeElement proxy = (TypeElement)element;
            DeclaredType proxySupertype = (DeclaredType)proxy.getSuperclass();
            if (proxySupertype == null) continue;
            TypeElement proxySupertypeElement = (TypeElement)proxySupertype.asElement();
            for (TypeMirror typeMirror : proxySupertypeElement.getInterfaces()) {
                DeclaredType publisherType = (DeclaredType)typeMirror;
                TypeElement publisherTypeElement = (TypeElement)publisherType.asElement();
                if (!publisherTypeElement.getInterfaces().isEmpty() || !AnnotationUtils.isAnnotationPresent((Element)publisherTypeElement, (ClassName)KafkaClassNames.kafkaPublisherAnnotation)) continue;
                list.add(new AopProxy(publisherTypeElement, proxy));
                continue block0;
            }
        }
        return list;
    }

    private record AopProxy(TypeElement publisher, TypeElement proxy) {
    }
}

