/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.producer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.RecordClassBuilder;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherAnnotationProcessor;
import ru.tinkoff.kora.kafka.annotation.processor.utils.KafkaPublisherUtils;

final class KafkaPublisherGenerator {
    private final Types types;
    private final Elements elements;
    private final ProcessingEnvironment processingEnv;

    KafkaPublisherGenerator(Types types, Elements elements, ProcessingEnvironment processingEnv) {
        this.types = types;
        this.elements = elements;
        this.processingEnv = processingEnv;
    }

    public void generatePublisherModule(TypeElement typeElement, List<ExecutableElement> publishMethods, AnnotationMirror publisherAnnotation, @Nullable TypeElement aopProxy) throws IOException {
        String packageName = this.elements.getPackageOf(typeElement).getQualifiedName().toString();
        String moduleName = NameUtils.generatedType((Element)typeElement, (String)"PublisherModule");
        TypeSpec.Builder module = TypeSpec.interfaceBuilder((String)moduleName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{KafkaPublisherAnnotationProcessor.class.getCanonicalName()})).build()).addAnnotation(CommonClassNames.module).addOriginatingElement((Element)typeElement).addModifiers(new Modifier[]{Modifier.PUBLIC});
        module.addMethod(this.buildPublisherFactoryFunction(typeElement, publishMethods, aopProxy));
        module.addMethod(this.buildPublisherFactoryImpl(typeElement));
        module.addMethod(this.buildProducerConfigMethod(typeElement, publisherAnnotation));
        module.addMethod(this.buildTopicConfigMethod(typeElement, publishMethods, publisherAnnotation));
        JavaFile.builder((String)packageName, (TypeSpec)module.build()).build().writeTo(this.processingEnv.getFiler());
    }

    private MethodSpec buildProducerConfigMethod(TypeElement publisher, AnnotationMirror publisherAnnotation) {
        String configPath = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)publisherAnnotation, (String)"value"));
        ClassName className = ClassName.get((TypeElement)publisher);
        return MethodSpec.methodBuilder((String)(CommonUtils.decapitalize((String)className.simpleName()) + "_PublisherConfig")).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)KafkaClassNames.publisherConfig).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{className}).build()).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{KafkaClassNames.publisherConfig}), "extractor", new Modifier[0]).addStatement("var configValue = config.get($S)", new Object[]{configPath}).addStatement("return $T.requireNonNull(extractor.extract(configValue))", new Object[]{Objects.class}).build();
    }

    private MethodSpec buildPublisherFactoryImpl(TypeElement publisher) {
        String packageName = this.elements.getPackageOf(publisher).getQualifiedName().toString();
        ClassName implementationName = ClassName.get((String)packageName, (String)NameUtils.generatedType((Element)publisher, (String)"Impl"), (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(CommonUtils.decapitalize((String)publisher.getSimpleName().toString()) + "_PublisherImpl")).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)ClassName.get((TypeElement)publisher)).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Properties.class), implementationName}), "factory", new Modifier[0]);
        builder.addStatement("return factory.apply(new $T())", new Object[]{Properties.class});
        return builder.build();
    }

    private MethodSpec buildPublisherFactoryFunction(TypeElement publisher, List<ExecutableElement> publishMethods, @Nullable TypeElement aopProxy) {
        AnnotationSpec propertiesTag = AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{publisher}).build();
        ParameterSpec config = ParameterSpec.builder((TypeName)KafkaClassNames.publisherConfig, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(propertiesTag).build();
        String packageName = this.elements.getPackageOf(publisher).getQualifiedName().toString();
        ClassName implementationName = ClassName.get((String)packageName, (String)NameUtils.generatedType((Element)publisher, (String)"Impl"), (String[])new String[0]);
        String topicConfigName = NameUtils.generatedType((Element)publisher, (String)"TopicConfig");
        ClassName topicConfigTypeName = ClassName.get((String)packageName, (String)topicConfigName, (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(CommonUtils.decapitalize((String)publisher.getSimpleName().toString()) + "_PublisherFactory")).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)KafkaClassNames.producerTelemetryFactory, "telemetryFactory", new Modifier[0]).addParameter(config).addParameter((TypeName)topicConfigTypeName, "topicConfig", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Properties.class), implementationName}));
        builder.addCode("return (additionalProperties) -> {$>\n", new Object[0]);
        builder.addStatement("var properties = new $T()", new Object[]{Properties.class});
        builder.addStatement("properties.putAll(config.driverProperties())", new Object[0]);
        builder.addStatement("properties.putAll(additionalProperties)", new Object[0]);
        builder.addCode("return new $T(telemetryFactory, config.telemetry(), properties, topicConfig$>", new Object[]{aopProxy == null ? implementationName : ClassName.get((TypeElement)aopProxy)});
        record TypeWithTag(TypeName typeName, Set<String> tag) {
        }
        HashMap<TypeWithTag, Object> parameters = new HashMap<TypeWithTag, Object>();
        AtomicInteger counter = new AtomicInteger(0);
        for (ExecutableElement publishMethod : publishMethods) {
            TypeWithTag valueType;
            Object valueParserName;
            ParameterSpec.Builder parameter;
            TypeWithTag keyType;
            Object keyParserName;
            KafkaPublisherUtils.PublisherData types = KafkaPublisherUtils.parsePublisherType(publishMethod);
            if (types.keyType() != null && (keyParserName = (String)parameters.get(keyType = new TypeWithTag(types.keyType(), types.keyTag()))) == null) {
                keyParserName = "serializer" + counter.incrementAndGet();
                parameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.serializer, (TypeName[])new TypeName[]{keyType.typeName()}), (String)keyParserName, (Modifier[])new Modifier[0]);
                Set<String> set = keyType.tag();
                if (!set.isEmpty()) {
                    parameter.addAnnotation(TagUtils.makeAnnotationSpec(set));
                }
                builder.addParameter(parameter.build());
                parameters.put(keyType, keyParserName);
                builder.addCode(", $N", new Object[]{keyParserName});
            }
            if ((valueParserName = (String)parameters.get(valueType = new TypeWithTag(types.valueType(), types.valueTag()))) != null) continue;
            valueParserName = "serializer" + counter.incrementAndGet();
            parameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.serializer, (TypeName[])new TypeName[]{valueType.typeName()}), (String)valueParserName, (Modifier[])new Modifier[0]);
            Set<String> set = valueType.tag();
            if (!set.isEmpty()) {
                parameter.addAnnotation(TagUtils.makeAnnotationSpec(set));
            }
            builder.addParameter(parameter.build());
            parameters.put(valueType, valueParserName);
            builder.addCode(", $N", new Object[]{valueParserName});
        }
        builder.addCode("$<\n", new Object[0]);
        if (aopProxy != null) {
            List constructors = CommonUtils.findConstructors((TypeElement)aopProxy, m -> m.contains((Object)Modifier.PUBLIC));
            if (constructors.size() != 1) {
                throw new ProcessingErrorException("Can't find aop proxy constructor", (Element)aopProxy);
            }
            ExecutableElement constructor = (ExecutableElement)constructors.get(0);
            for (int i = 4 + counter.get(); i < constructor.getParameters().size(); ++i) {
                VariableElement param = constructor.getParameters().get(i);
                ParameterSpec.Builder b = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)param.asType()), (String)param.getSimpleName().toString(), (Modifier[])new Modifier[0]);
                for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
                    b.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
                }
                builder.addParameter(b.build());
                builder.addCode(", $N", new Object[]{param.getSimpleName()});
            }
        }
        builder.addCode(");$<\n", new Object[0]);
        builder.addCode("};\n", new Object[0]);
        return builder.build();
    }

    public void generatePublisherImplementation(TypeElement publisher, List<ExecutableElement> publishMethods, AnnotationMirror publisherAnnotation) throws IOException {
        String packageName = this.elements.getPackageOf(publisher).getQualifiedName().toString();
        String implementationName = NameUtils.generatedType((Element)publisher, (String)"Impl");
        String topicConfigName = NameUtils.generatedType((Element)publisher, (String)"TopicConfig");
        ClassName topicConfigTypeName = ClassName.get((String)packageName, (String)topicConfigName, (String[])new String[0]);
        TypeSpec.Builder b = CommonUtils.extendsKeepAop((TypeElement)publisher, (String)implementationName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{KafkaPublisherAnnotationProcessor.class.getCanonicalName()})).build()).addOriginatingElement((Element)publisher).addSuperinterface((TypeName)KafkaClassNames.generatedPublisher).addField((TypeName)CommonClassNames.telemetryConfig, "telemetryConfig", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)ClassName.get(Properties.class), "driverProperties", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)topicConfigTypeName, "topicConfig", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)KafkaClassNames.producerTelemetryFactory, "telemetryFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.producer, (TypeName[])new TypeName[]{ArrayTypeName.of((TypeName)TypeName.BYTE), ArrayTypeName.of((TypeName)TypeName.BYTE)}), "delegate", new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).addField((TypeName)KafkaClassNames.producerTelemetry, "telemetry", new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).addMethod(MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addCode("this.delegate = new $T<>(driverProperties, new $T(), new $T());\n", new Object[]{KafkaClassNames.kafkaProducer, KafkaClassNames.byteArraySerializer, KafkaClassNames.byteArraySerializer}).addCode("this.telemetry = this.telemetryFactory.get(this.telemetryConfig, this.delegate, driverProperties);\n", new Object[]{KafkaClassNames.kafkaProducer}).build()).addMethod(MethodSpec.methodBuilder((String)"release").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).beginControlFlow("if (this.delegate != null)", new Object[0]).addStatement("this.delegate.close()", new Object[0]).addStatement("this.delegate = null", new Object[0]).beginControlFlow("if (this.telemetry != null)", new Object[0]).addStatement("this.telemetry.close()", new Object[0]).addStatement("this.telemetry = null", new Object[0]).endControlFlow().endControlFlow().build()).addMethod(MethodSpec.methodBuilder((String)"telemetry").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)KafkaClassNames.producerTelemetry).addCode("return telemetry;", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"producer").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.producer, (TypeName[])new TypeName[]{ArrayTypeName.of((TypeName)TypeName.BYTE), ArrayTypeName.of((TypeName)TypeName.BYTE)})).addStatement("return this.delegate", new Object[0]).build());
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)KafkaClassNames.producerTelemetryFactory, "telemetryFactory", new Modifier[0]).addParameter((TypeName)CommonClassNames.telemetryConfig, "telemetryConfig", new Modifier[0]).addStatement("this.telemetryConfig = telemetryConfig", new Object[0]).addParameter((TypeName)ClassName.get(Properties.class), "driverProperties", new Modifier[0]).addParameter((TypeName)topicConfigTypeName, "topicConfig", new Modifier[0]).addStatement("this.driverProperties = driverProperties", new Object[0]).addStatement("this.telemetryFactory = telemetryFactory", new Object[0]).addStatement("this.topicConfig = topicConfig", new Object[0]);
        record TypeWithTag(TypeName typeName, Set<String> tag) {
        }
        HashMap<TypeWithTag, Object> parameters = new HashMap<TypeWithTag, Object>();
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < publishMethods.size(); ++i) {
            TypeWithTag valueType;
            Object valueParserName;
            TypeWithTag keyType;
            ExecutableElement publishMethod = publishMethods.get(i);
            KafkaPublisherUtils.PublisherData publishData = KafkaPublisherUtils.parsePublisherType(publishMethod);
            Object keyParserName = null;
            if (publishData.keyType() != null && (keyParserName = (String)parameters.get(keyType = new TypeWithTag(publishData.keyType(), publishData.keyTag()))) == null) {
                keyParserName = "serializer" + counter.incrementAndGet();
                ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)KafkaClassNames.serializer, (TypeName[])new TypeName[]{keyType.typeName()});
                b.addField((TypeName)type, (String)keyParserName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)type, (String)keyParserName, (Modifier[])new Modifier[0]);
                Set<String> tags = keyType.tag();
                if (!tags.isEmpty()) {
                    parameter.addAnnotation(TagUtils.makeAnnotationSpec(tags));
                }
                constructorBuilder.addParameter(parameter.build());
                constructorBuilder.addStatement("this.$N = $N", new Object[]{keyParserName, keyParserName});
                parameters.put(keyType, keyParserName);
            }
            if ((valueParserName = (String)parameters.get(valueType = new TypeWithTag(publishData.valueType(), publishData.valueTag()))) == null) {
                valueParserName = "serializer" + counter.incrementAndGet();
                ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)KafkaClassNames.serializer, (TypeName[])new TypeName[]{valueType.typeName()});
                b.addField((TypeName)type, (String)valueParserName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)type, (String)valueParserName, (Modifier[])new Modifier[0]);
                Set<String> tags = valueType.tag();
                if (!tags.isEmpty()) {
                    parameter.addAnnotation(TagUtils.makeAnnotationSpec(tags));
                }
                constructorBuilder.addParameter(parameter.build());
                constructorBuilder.addStatement("this.$N = $N", new Object[]{valueParserName, valueParserName});
                parameters.put(valueType, valueParserName);
            }
            String topicVariable = "topic" + i;
            MethodSpec method = this.generatePublisherExecutableMethod(publishMethod, publishData, topicVariable, (String)keyParserName, (String)valueParserName);
            b.addMethod(method);
        }
        b.addMethod(constructorBuilder.build());
        JavaFile.builder((String)packageName, (TypeSpec)b.build()).build().writeTo(this.processingEnv.getFiler());
    }

    /*
     * Unable to fully structure code
     */
    private MethodSpec generatePublisherExecutableMethod(ExecutableElement publishMethod, KafkaPublisherUtils.PublisherData publishData, String topicVariable, String keyParserName, String valueParserName) {
        block15: {
            block14: {
                methodBuilder = CommonUtils.overridingKeepAop((ExecutableElement)publishMethod);
                b = CodeBlock.builder();
                if (publishData.recordVar() != null) {
                    record = publishData.recordVar().getSimpleName();
                    b.addStatement("var _headers = $N.headers()", new Object[]{record});
                    b.addStatement("var _key = $N.serialize($N.topic(), _headers, $N.key())", new Object[]{keyParserName, record, record});
                    b.addStatement("var _value = $N.serialize($N.topic(), _headers, $N.value())", new Object[]{valueParserName, record, record});
                    b.addStatement("var _record = new $T<>($N.topic(), $N.partition(), $N.timestamp(), _key, _value, _headers)", new Object[]{KafkaClassNames.producerRecord, record, record, record});
                } else {
                    b.addStatement("var _topic = this.topicConfig.$N().topic()", new Object[]{topicVariable});
                    b.addStatement("var _partition = this.topicConfig.$N().partition()", new Object[]{topicVariable});
                    if (publishData.headersVar() == null) {
                        b.addStatement("var _headers = new $T()", new Object[]{KafkaClassNames.recordHeaders});
                    } else {
                        b.addStatement("var _headers = $N", new Object[]{publishData.headersVar().getSimpleName()});
                    }
                    if (publishData.keyVar() == null) {
                        b.addStatement("byte[] _key = null", new Object[0]);
                    } else {
                        b.addStatement("var _key = $N.serialize(_topic, _headers, $N)", new Object[]{keyParserName, publishData.keyVar().getSimpleName()});
                    }
                    b.addStatement("var _value = $N.serialize(_topic, _headers, $N)", new Object[]{valueParserName, publishData.valueVar().getSimpleName()});
                    b.addStatement("var _record = new $T<>(_topic, _partition, null, _key, _value, _headers)", new Object[]{KafkaClassNames.producerRecord});
                }
                b.addStatement("var _tctx = this.telemetry.record(_record)", new Object[0]);
                returnType = TypeName.get((TypeMirror)publishMethod.getReturnType());
                if (!(returnType instanceof ParameterizedTypeName)) break block14;
                ptn = (ParameterizedTypeName)returnType;
                if (!ptn.rawType.equals((Object)ClassName.get(Future.class))) break block14;
                if (publishData.callback() != null) {
                    b.add("return this.delegate.send(_record, (_meta, _ex) -> {$>\n", new Object[0]);
                    b.addStatement("_tctx.onCompletion(_meta, _ex)", new Object[0]);
                    b.addStatement("$N.onCompletion(_meta, _ex)", new Object[]{publishData.callback().getSimpleName()});
                    b.add("$<\n});\n", new Object[0]);
                } else {
                    b.add("return this.delegate.send(_record, _tctx);", new Object[0]);
                }
                break block15;
            }
            if (!(returnType instanceof ParameterizedTypeName)) ** GOTO lbl-1000
            ptn = (ParameterizedTypeName)returnType;
            if (ptn.rawType.equals((Object)ClassName.get(CompletionStage.class)) || ptn.rawType.equals((Object)ClassName.get(CompletableFuture.class))) {
                b.addStatement("var _future = new $T<$T>()", new Object[]{CompletableFuture.class, KafkaClassNames.recordMetadata});
                b.add("this.delegate.send(_record, (_meta, _ex) -> {$>\n", new Object[0]);
                b.addStatement("_tctx.onCompletion(_meta, _ex)", new Object[0]);
                if (publishData.callback() != null) {
                    b.addStatement("$N.onCompletion(_meta, _ex)", new Object[]{publishData.callback().getSimpleName()});
                }
                b.beginControlFlow("if (_ex != null)", new Object[0]);
                b.addStatement("_future.completeExceptionally(_ex)", new Object[0]);
                b.nextControlFlow("else", new Object[0]);
                b.addStatement("_future.complete(_meta)", new Object[0]);
                b.endControlFlow();
                b.add("$<\n});\n", new Object[0]);
                b.addStatement("return _future", new Object[0]);
            } else lbl-1000:
            // 2 sources

            {
                b.add("try {$>\n", new Object[0]);
                if (!MethodUtils.isVoid((ExecutableElement)publishMethod)) {
                    b.add("return ", new Object[0]);
                }
                if (publishData.callback() != null) {
                    b.add("this.delegate.send(_record, (_meta, _ex) -> {$>\n", new Object[0]);
                    b.addStatement("_tctx.onCompletion(_meta, _ex)", new Object[0]);
                    b.add("$N.onCompletion(_meta, _ex);", new Object[]{publishData.callback().getSimpleName()});
                    b.add("$<\n}).get();", new Object[0]);
                } else {
                    b.add("this.delegate.send(_record, _tctx).get();", new Object[0]);
                }
                b.add("$<\n} catch (InterruptedException e) {$>\n", new Object[0]);
                b.add("throw new $T(e);", new Object[]{KafkaClassNames.recordPublisherException});
                b.add("$<\n} catch ($T e) {$>\n", new Object[]{ExecutionException.class});
                b.add("if (e.getCause() instanceof RuntimeException re) throw re;\n", new Object[0]);
                b.add("if (e.getCause() != null) throw new $T(e.getCause());\n", new Object[]{KafkaClassNames.recordPublisherException});
                b.add("throw new $T(e);", new Object[]{KafkaClassNames.recordPublisherException});
                b.add("$<\n} catch (Exception e) {$>\n", new Object[0]);
                b.add("if (e.getCause() != null) throw new $T(e.getCause());\n", new Object[]{KafkaClassNames.recordPublisherException});
                b.add("throw new $T(e);", new Object[]{KafkaClassNames.recordPublisherException});
                b.add("$<\n}\n", new Object[0]);
            }
        }
        methodBuilder.addCode(b.build());
        return methodBuilder.build();
    }

    public void generateConfig(TypeElement producer, List<ExecutableElement> publishMethods) throws IOException {
        RecordClassBuilder record = new RecordClassBuilder(NameUtils.generatedType((Element)producer, (String)"TopicConfig"), KafkaPublisherAnnotationProcessor.class).addModifier(Modifier.PUBLIC).originatingElement((Element)producer);
        for (int i = 0; i < publishMethods.size(); ++i) {
            if (!AnnotationUtils.isAnnotationPresent((Element)publishMethods.get(0), (ClassName)KafkaClassNames.kafkaTopicAnnotation)) continue;
            record.addComponent("topic" + i, (TypeName)KafkaClassNames.publisherTopicConfig);
        }
        String packageName = this.elements.getPackageOf(producer).getQualifiedName().toString();
        record.writeTo(this.processingEnv.getFiler(), packageName);
    }

    public MethodSpec buildTopicConfigMethod(TypeElement producer, List<ExecutableElement> publishMethods, AnnotationMirror publisherAnnotation) {
        String packageName = this.elements.getPackageOf(producer).getQualifiedName().toString();
        String configName = NameUtils.generatedType((Element)producer, (String)"TopicConfig");
        ClassName configTypeName = ClassName.get((String)packageName, (String)configName, (String[])new String[0]);
        MethodSpec.Builder m = MethodSpec.methodBuilder((String)CommonUtils.decapitalize((String)configName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{KafkaClassNames.publisherTopicConfig}), "parser", new Modifier[0]).returns((TypeName)configTypeName).addCode("return new $T(\n$>", new Object[]{configTypeName});
        String root = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)publisherAnnotation, (String)"value"));
        for (int i = 0; i < publishMethods.size(); ++i) {
            ExecutableElement method = publishMethods.get(i);
            AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)KafkaClassNames.kafkaTopicAnnotation);
            if (annotation == null) continue;
            Object path = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"value"));
            if (((String)path).startsWith(".")) {
                path = root + (String)path;
            }
            if (i > 0) {
                m.addCode(",\n", new Object[0]);
            }
            m.addCode("parser.extract(config.get($S))", new Object[]{path});
        }
        m.addCode("$<\n);\n", new Object[0]);
        return m.build();
    }
}

