/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.producer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.annotation.processor.producer.KafkaPublisherAnnotationProcessor;

final class KafkaPublisherTransactionalGenerator {
    private final Types types;
    private final Elements elements;
    private final ProcessingEnvironment processingEnv;

    KafkaPublisherTransactionalGenerator(Types types, Elements elements, ProcessingEnvironment processingEnv) {
        this.types = types;
        this.elements = elements;
        this.processingEnv = processingEnv;
    }

    public void generatePublisherTransactionalModule(TypeElement typeElement, TypeElement publisherTypeElement, AnnotationMirror annotation) throws IOException {
        String packageName = this.elements.getPackageOf(typeElement).getQualifiedName().toString();
        String implementationName = NameUtils.generatedType((Element)typeElement, (String)"Impl");
        ClassName implementationTypeName = ClassName.get((String)packageName, (String)implementationName, (String[])new String[0]);
        String publisherPackageName = this.elements.getPackageOf(publisherTypeElement).getQualifiedName().toString();
        ClassName publisherImplementationTypeName = ClassName.get((String)publisherPackageName, (String)NameUtils.generatedType((Element)publisherTypeElement, (String)"Impl"), (String[])new String[0]);
        String moduleName = NameUtils.generatedType((Element)typeElement, (String)"Module");
        TypeSpec.Builder module = TypeSpec.interfaceBuilder((String)moduleName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{KafkaPublisherAnnotationProcessor.class.getCanonicalName()})).build()).addAnnotation(CommonClassNames.module).addOriginatingElement((Element)typeElement).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String configPath = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"value"));
        AnnotationSpec tag = AnnotationSpec.builder((ClassName)CommonClassNames.tag).addMember("value", "$T.class", new Object[]{ClassName.get((TypeElement)typeElement)}).build();
        MethodSpec config = MethodSpec.methodBuilder((String)(CommonUtils.decapitalize((String)typeElement.getSimpleName().toString()) + "_PublisherTransactionalConfig")).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)KafkaClassNames.publisherTransactionalConfig).addAnnotation(tag).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{KafkaClassNames.publisherTransactionalConfig}), "extractor", new Modifier[0]).addStatement("var configValue = config.get($S)", new Object[]{configPath}).addStatement("return $T.requireNonNull(extractor.extract(configValue))", new Object[]{Objects.class}).build();
        MethodSpec publisher = MethodSpec.methodBuilder((String)(CommonUtils.decapitalize((String)typeElement.getSimpleName().toString()) + "_PublisherTransactional")).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Properties.class), publisherImplementationTypeName}), "factory", new Modifier[0]).addParameter(ParameterSpec.builder((TypeName)KafkaClassNames.publisherTransactionalConfig, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(tag).build()).returns((TypeName)ClassName.get((TypeElement)typeElement)).addCode("return new $T(config, () -> {$>\n", new Object[]{implementationTypeName}).addStatement("var properties = new $T()", new Object[]{Properties.class}).addStatement("properties.put(org.apache.kafka.clients.producer.ProducerConfig.TRANSACTIONAL_ID_CONFIG, config.idPrefix() + \"-\" + $T.randomUUID())", new Object[]{UUID.class}).addStatement("return factory.apply(properties)", new Object[0]).addCode("$<\n});\n", new Object[0]).build();
        module.addMethod(config);
        module.addMethod(publisher);
        JavaFile.builder((String)packageName, (TypeSpec)module.build()).build().writeTo(this.processingEnv.getFiler());
    }

    public void generatePublisherTransactionalImpl(TypeElement typeElement, ClassName publisherType, TypeElement publisherTypeElement) throws IOException {
        String packageName = this.elements.getPackageOf(typeElement).getQualifiedName().toString();
        String publisherPackageName = this.elements.getPackageOf(publisherTypeElement).getQualifiedName().toString();
        String implementationName = NameUtils.generatedType((Element)typeElement, (String)"Impl");
        ClassName publisherImplementationTypeName = ClassName.get((String)publisherPackageName, (String)NameUtils.generatedType((Element)publisherTypeElement, (String)"Impl"), (String[])new String[0]);
        TypeSpec b = CommonUtils.extendsKeepAop((TypeElement)typeElement, (String)implementationName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{KafkaPublisherAnnotationProcessor.class.getCanonicalName()})).build()).addSuperinterface((TypeName)CommonClassNames.lifecycle).addOriginatingElement((Element)typeElement).addField((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.transactionalPublisherImpl, (TypeName[])new TypeName[]{publisherImplementationTypeName}), "delegate", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)KafkaClassNames.publisherTransactionalConfig, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{publisherImplementationTypeName}), "factory", new Modifier[0]).addStatement("this.delegate = new $T<>(config, factory)", new Object[]{KafkaClassNames.transactionalPublisherImpl}).build()).addMethod(MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addStatement("this.delegate.init()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"release").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addException(Exception.class).addStatement("this.delegate.release()", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"begin").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)KafkaClassNames.transaction, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)publisherType)})).addStatement("return this.delegate.begin()", new Object[0]).build()).build();
        JavaFile.builder((String)packageName, (TypeSpec)b).build().writeTo(this.processingEnv.getFiler());
    }
}

