/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.annotation.processor.utils;

import com.squareup.javapoet.ClassName;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.kafka.annotation.processor.KafkaClassNames;

public final class KafkaUtils {
    private KafkaUtils() {
    }

    public static String prepareProducerTagName(TypeElement type) {
        AnnotationMirror producerAnnotation = AnnotationUtils.findAnnotation((Element)type, (ClassName)KafkaClassNames.kafkaPublisherAnnotation);
        String configPath = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)producerAnnotation, (String)"value"));
        return "KafkaProducer_" + CommonUtils.capitalize((String)configPath.replace(".", "_").replace("-", "_")) + "Tag";
    }

    public static String prepareConsumerTagName(ExecutableElement method) {
        String controllerName = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        return CommonUtils.capitalize((String)controllerName) + CommonUtils.capitalize((String)methodName) + "Tag";
    }

    public static String prepareMethodName(ExecutableElement method, String suffix) {
        String controllerName = method.getEnclosingElement().getSimpleName().toString();
        String methodName = method.getSimpleName().toString();
        return CommonUtils.decapitalize((String)controllerName) + CommonUtils.capitalize((String)methodName) + suffix;
    }

    public static boolean isConsumerRecord(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.consumerRecord);
    }

    public static boolean isConsumerRecords(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.consumerRecords);
    }

    public static boolean isProducerRecord(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.producerRecord);
    }

    public static boolean isProducerCallback(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.producerCallback);
    }

    public static boolean isHeaders(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.headers);
    }

    public static boolean isHeader(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.header);
    }

    public static boolean isKeyDeserializationException(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.recordKeyDeserializationException);
    }

    public static boolean isValueDeserializationException(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.recordValueDeserializationException);
    }

    public static boolean isAnyException(TypeMirror tm) {
        return tm.toString().equals("java.lang.Throwable") || tm.toString().equals("java.lang.Exception");
    }

    public static boolean isRecordsTelemetry(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.kafkaConsumerRecordsTelemetry);
    }

    public static boolean isConsumer(TypeMirror tm) {
        DeclaredType dt;
        return tm instanceof DeclaredType && ClassName.get((TypeElement)((TypeElement)(dt = (DeclaredType)tm).asElement())).equals((Object)KafkaClassNames.consumer);
    }
}

