/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.kafka.symbol.processor.consumer;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.kafka.symbol.processor.KafkaClassNames;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.ConsumerParameter;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaConsumerConfigGenerator;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaContainerGenerator;
import ru.tinkoff.kora.kafka.symbol.processor.consumer.KafkaHandlerGenerator;
import ru.tinkoff.kora.ksp.common.AnnotationUtils;
import ru.tinkoff.kora.ksp.common.CommonClassNames;
import ru.tinkoff.kora.ksp.common.KspCommonUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaConsumerModuleGenerator;", "", "kafkaHandlerGenerator", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator;", "kafkaConfigGenerator", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaConsumerConfigGenerator;", "kafkaContainerGenerator", "Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaContainerGenerator;", "(Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaHandlerGenerator;Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaConsumerConfigGenerator;Lru/tinkoff/kora/kafka/symbol/processor/consumer/KafkaContainerGenerator;)V", "generateModule", "Lcom/squareup/kotlinpoet/FileSpec;", "declaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "kafka-symbol-processor"})
public final class KafkaConsumerModuleGenerator {
    @NotNull
    private final KafkaHandlerGenerator kafkaHandlerGenerator;
    @NotNull
    private final KafkaConsumerConfigGenerator kafkaConfigGenerator;
    @NotNull
    private final KafkaContainerGenerator kafkaContainerGenerator;

    public KafkaConsumerModuleGenerator(@NotNull KafkaHandlerGenerator kafkaHandlerGenerator, @NotNull KafkaConsumerConfigGenerator kafkaConfigGenerator, @NotNull KafkaContainerGenerator kafkaContainerGenerator) {
        Intrinsics.checkNotNullParameter((Object)kafkaHandlerGenerator, (String)"kafkaHandlerGenerator");
        Intrinsics.checkNotNullParameter((Object)kafkaConfigGenerator, (String)"kafkaConfigGenerator");
        Intrinsics.checkNotNullParameter((Object)kafkaContainerGenerator, (String)"kafkaContainerGenerator");
        this.kafkaHandlerGenerator = kafkaHandlerGenerator;
        this.kafkaConfigGenerator = kafkaConfigGenerator;
        this.kafkaContainerGenerator = kafkaContainerGenerator;
    }

    @NotNull
    public final FileSpec generateModule(@NotNull KSClassDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        TypeSpec.Builder builder = TypeSpec.Companion.interfaceBuilder(declaration.getSimpleName().asString() + "Module");
        KSFile kSFile = declaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        TypeSpec.Builder classBuilder = KspCommonUtils.INSTANCE.generated(OriginatingKSFilesKt.addOriginatingKSFile((TypeSpec.Builder)builder, (KSFile)kSFile), Reflection.getOrCreateKotlinClass(KafkaConsumerModuleGenerator.class));
        classBuilder.addAnnotation(AnnotationSpec.Companion.builder(CommonClassNames.INSTANCE.getModule()).build());
        for (KSFunctionDeclaration function : UtilsKt.getDeclaredFunctions((KSClassDeclaration)declaration)) {
            KSAnnotation kafkaListener = AnnotationUtils.INSTANCE.findAnnotation((KSAnnotated)function, KafkaClassNames.INSTANCE.getKafkaListener());
            if (kafkaListener == null) continue;
            KafkaConsumerConfigGenerator.KafkaConfigData configTagData = this.kafkaConfigGenerator.generate(function, kafkaListener);
            classBuilder.addFunction(configTagData.getConfigFunction());
            classBuilder.addType(configTagData.getTag());
            List<ConsumerParameter> parameters = ConsumerParameter.Companion.parseParameters(function);
            KafkaHandlerGenerator.HandlerFunction handler = this.kafkaHandlerGenerator.generate(function, parameters);
            classBuilder.addFunction(handler.getFunSpec());
            FunSpec container = this.kafkaContainerGenerator.generate(function, handler, parameters);
            classBuilder.addFunction(container);
        }
        String packageName = declaration.getPackageName().asString();
        return FileSpec.Companion.get(packageName, classBuilder.build());
    }
}

