/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.common;

import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.logging.common.LoggingConfig;

public final class LoggingConfigValueExtractor
implements ConfigValueExtractor<LoggingConfig> {
    public LoggingConfig extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.NullValue) {
            return new LoggingConfig(Map.of("ROOT", "info"));
        }
        if (!(value instanceof ConfigValue.ObjectValue)) {
            throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ObjectValue.class);
        }
        ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
        LinkedHashMap<String, String> levels = new LinkedHashMap<String, String>();
        ConfigValue levelsObject = objectValue.get("levels");
        if (levelsObject instanceof ConfigValue.NullValue) {
            levelsObject = objectValue.get("level");
        }
        if (levelsObject instanceof ConfigValue.NullValue) {
            return new LoggingConfig(levels);
        }
        if (levelsObject instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue l = (ConfigValue.ObjectValue)levelsObject;
            for (Map.Entry entry : l) {
                this.collectLevels("", (String)entry.getKey(), (ConfigValue)entry.getValue(), levels);
            }
            return new LoggingConfig(levels);
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ObjectValue.class);
    }

    private void collectLevels(String previousPath, String key, ConfigValue<?> value, Map<String, String> accumulator) {
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue str = (ConfigValue.StringValue)value;
            accumulator.put(previousPath + key, str.value());
        } else if (value instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
            for (Map.Entry entry : objectValue) {
                this.collectLevels(previousPath + key + ".", (String)entry.getKey(), (ConfigValue)entry.getValue(), accumulator);
            }
        }
    }
}

