/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.common;

import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.logging.common.LoggingConfig;
import ru.tinkoff.kora.logging.common.LoggingConfigValueExtractor;
import ru.tinkoff.kora.logging.common.LoggingLevelApplier;
import ru.tinkoff.kora.logging.common.LoggingLevelRefresher;

public interface LoggingModule {
    default public ConfigValueExtractor<LoggingConfig> loggingLevelConfigValueExtractor() {
        return new LoggingConfigValueExtractor();
    }

    @Root
    default public LoggingLevelRefresher loggingLevelRefresher(LoggingConfig loggingConfig, LoggingLevelApplier loggingLevelApplier) {
        return new LoggingLevelRefresher(loggingConfig, loggingLevelApplier);
    }

    default public LoggingConfig loggingConfig(Config config, ConfigValueExtractor<LoggingConfig> extractor) {
        ConfigValue value = config.get("logging");
        if (value == null) {
            return new LoggingConfig(Map.of());
        }
        return (LoggingConfig)extractor.extract(value);
    }

    default public ILoggerFactory loggerFactory() {
        return LoggerFactory.getILoggerFactory();
    }
}

