/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.common;

import com.fasterxml.jackson.core.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.logging.common.arg.StructuredArgumentWriter;

public class MDC {
    private final ConcurrentHashMap<String, StructuredArgumentWriter> values;
    private static final Context.Key<MDC> MDC = new Context.Key<MDC>(){

        protected MDC copy(MDC object) {
            return object == null ? new MDC() : new MDC(object.values);
        }
    };

    private MDC() {
        this.values = new ConcurrentHashMap();
    }

    private MDC(ConcurrentHashMap<String, StructuredArgumentWriter> values) {
        this.values = new ConcurrentHashMap<String, StructuredArgumentWriter>(values);
    }

    public Map<String, StructuredArgumentWriter> values() {
        return Collections.unmodifiableMap(this.values);
    }

    public void remove0(String key) {
        this.values.remove(key);
    }

    public void put0(String key, StructuredArgumentWriter value) {
        this.values.put(key, value);
    }

    public void put0(String key, Integer value) {
        if (value == null) {
            this.values.put(key, JsonGenerator::writeNull);
        } else {
            this.values.put(key, gen -> gen.writeNumber(value.intValue()));
        }
    }

    public void put0(String key, Long value) {
        if (value == null) {
            this.values.put(key, JsonGenerator::writeNull);
        } else {
            this.values.put(key, gen -> gen.writeNumber(value.longValue()));
        }
    }

    public void put0(String key, String value) {
        if (value == null) {
            this.values.put(key, JsonGenerator::writeNull);
        } else {
            this.values.put(key, gen -> gen.writeString(value));
        }
    }

    public void put0(String key, Boolean value) {
        if (value == null) {
            this.values.put(key, JsonGenerator::writeNull);
        } else {
            this.values.put(key, gen -> gen.writeBoolean(value.booleanValue()));
        }
    }

    public static MDC get(Context ctx) {
        MDC mdc = (MDC)ctx.get(MDC);
        if (mdc == null) {
            mdc = new MDC();
            ctx.set(MDC, (Object)mdc);
        }
        return mdc;
    }

    public static MDC get() {
        return ru.tinkoff.kora.logging.common.MDC.get(Context.current());
    }

    public static void put(String key, String value) {
        ru.tinkoff.kora.logging.common.MDC.get().put0(key, value);
    }

    public static void put(String key, Integer value) {
        ru.tinkoff.kora.logging.common.MDC.get().put0(key, value);
    }

    public static void put(String key, Long value) {
        ru.tinkoff.kora.logging.common.MDC.get().put0(key, value);
    }

    public static void put(String key, Boolean value) {
        ru.tinkoff.kora.logging.common.MDC.get().put0(key, value);
    }

    public static void put(String key, StructuredArgumentWriter value) {
        ru.tinkoff.kora.logging.common.MDC.get().put0(key, value);
    }

    public static void put(Context ctx, String key, StructuredArgumentWriter value) {
        ru.tinkoff.kora.logging.common.MDC.get(ctx).put0(key, value);
    }

    public static void remove(String key) {
        ru.tinkoff.kora.logging.common.MDC.get().remove0(key);
    }
}

