/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.logging.common.arg;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Marker;
import ru.tinkoff.kora.json.common.JsonWriter;
import ru.tinkoff.kora.logging.common.arg.ArgumentMarkerWithValueAndWriter;
import ru.tinkoff.kora.logging.common.arg.ArgumentMarkerWithWriter;
import ru.tinkoff.kora.logging.common.arg.ArgumentWithValueAndWriter;
import ru.tinkoff.kora.logging.common.arg.ArgumentWithWriter;
import ru.tinkoff.kora.logging.common.arg.StructuredArgumentWriter;

public interface StructuredArgument
extends StructuredArgumentWriter {
    public String fieldName();

    public static <T> StructuredArgument arg(String fieldName, @Nullable T value, JsonWriter<T> writer) {
        return new ArgumentWithValueAndWriter<T>(fieldName, value, writer);
    }

    public static StructuredArgument arg(String fieldName, StructuredArgumentWriter writer) {
        return new ArgumentWithWriter(fieldName, writer);
    }

    public static StructuredArgument arg(String fieldName, String value) {
        return new ArgumentWithValueAndWriter<String>(fieldName, value, JsonGenerator::writeString);
    }

    public static StructuredArgument arg(String fieldName, Integer value) {
        return new ArgumentWithValueAndWriter<Integer>(fieldName, value, JsonGenerator::writeNumber);
    }

    public static StructuredArgument arg(String fieldName, Long value) {
        return new ArgumentWithValueAndWriter<Long>(fieldName, value, JsonGenerator::writeNumber);
    }

    public static StructuredArgument arg(String fieldName, Boolean value) {
        return new ArgumentWithValueAndWriter<Boolean>(fieldName, value, JsonGenerator::writeBoolean);
    }

    public static StructuredArgument arg(String fieldName, Map<String, String> value) {
        return new ArgumentWithValueAndWriter<Map<String, String>>(fieldName, value, (gen, object) -> {
            gen.writeStartObject(object);
            for (Map.Entry entry : object.entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                gen.writeString((String)entry.getValue());
            }
            gen.writeEndObject();
        });
    }

    public static <T> Marker marker(String fieldName, @Nullable T value, JsonWriter<T> writer) {
        return new ArgumentMarkerWithValueAndWriter<T>(fieldName, value, writer);
    }

    public static Marker marker(String fieldName, StructuredArgumentWriter writer) {
        return new ArgumentMarkerWithWriter(fieldName, writer);
    }

    public static Marker marker(String fieldName, String value) {
        return new ArgumentMarkerWithValueAndWriter<String>(fieldName, value, JsonGenerator::writeString);
    }

    public static Marker marker(String fieldName, Integer value) {
        return new ArgumentMarkerWithValueAndWriter<Integer>(fieldName, value, JsonGenerator::writeNumber);
    }

    public static Marker marker(String fieldName, Long value) {
        return new ArgumentMarkerWithValueAndWriter<Long>(fieldName, value, JsonGenerator::writeNumber);
    }

    public static Marker marker(String fieldName, Boolean value) {
        return new ArgumentMarkerWithValueAndWriter<Boolean>(fieldName, value, JsonGenerator::writeBoolean);
    }

    public static Marker marker(String fieldName, Map<String, String> value) {
        return new ArgumentMarkerWithValueAndWriter<Map<String, String>>(fieldName, value, (gen, object) -> {
            gen.writeStartObject(object);
            for (Map.Entry entry : object.entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                gen.writeString((String)entry.getValue());
            }
            gen.writeEndObject();
        });
    }
}

