/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.mapstruct.java.extension;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public final class MapstructKoraExtension
implements KoraExtension {
    static final ClassName MAPPER_ANNOTATION = ClassName.get((String)"org.mapstruct", (String)"Mapper", (String[])new String[0]);
    private static final String IMPLEMENTATION_SUFFIX = "Impl";
    private final ProcessingEnvironment env;

    public MapstructKoraExtension(ProcessingEnvironment env) {
        this.env = env;
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType dtm = (DeclaredType)typeMirror;
        Element element = dtm.asElement();
        if (element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.CLASS) {
            return null;
        }
        AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)MAPPER_ANNOTATION);
        if (annotation == null) {
            return null;
        }
        Set tag = TagUtils.parseTagValue((AnnotatedConstruct)dtm);
        if (!tag.equals(tags)) {
            return null;
        }
        return () -> {
            String packageName = this.env.getElementUtils().getPackageOf(element).getQualifiedName().toString();
            String expectedName = this.getMapstructMapperName(element);
            TypeElement implementation = this.env.getElementUtils().getTypeElement(packageName + "." + expectedName);
            if (implementation == null) {
                return ExtensionResult.nextRound();
            }
            List constructor = CommonUtils.findConstructors((TypeElement)implementation, m -> m.contains((Object)Modifier.PUBLIC));
            if (constructor.size() != 1) {
                throw new ProcessingErrorException("Generated mapstruct class has unexpected number of constructors", (Element)implementation);
            }
            return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructor.get(0)));
        };
    }

    private String getMapstructMapperName(Element element) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(element.getSimpleName().toString());
        Element parent = element.getEnclosingElement();
        while (parent.getKind() != ElementKind.PACKAGE) {
            parts.add(parent.getSimpleName().toString());
            parent = parent.getEnclosingElement();
        }
        Collections.reverse(parts);
        return String.join((CharSequence)"$", parts) + IMPLEMENTATION_SUFFIX;
    }
}

