/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.cache;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.cache.telemetry.CacheMetrics;
import ru.tinkoff.kora.cache.telemetry.CacheTelemetryOperation;

public final class MicrometerCacheMetrics
implements CacheMetrics {
    private static final String METRIC_CACHE_DURATION = "cache.duration";
    private static final String METRIC_CACHE_RATIO = "cache.ratio";
    private static final String METRIC_CACHE_HIT = "cache.hit";
    private static final String METRIC_CACHE_MISS = "cache.miss";
    private static final String TAG_OPERATION = "operation";
    private static final String TAG_CACHE_NAME = "cache";
    private static final String TAG_ORIGIN = "origin";
    private static final String TAG_STATUS = "status";
    private static final String TAG_TYPE = "type";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_FAILED = "failed";
    private static final String TYPE_HIT = "hit";
    private static final String TYPE_MISS = "miss";
    private final ConcurrentHashMap<Key, Timer> durations = new ConcurrentHashMap();
    private final ConcurrentHashMap<RatioKey, Counter> counters = new ConcurrentHashMap();
    @Deprecated(forRemoval=true)
    private final ConcurrentHashMap<OpKey, Counter> missCounters = new ConcurrentHashMap();
    @Deprecated(forRemoval=true)
    private final ConcurrentHashMap<OpKey, Counter> hitCounters = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;

    public MicrometerCacheMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void recordSuccess(@Nonnull CacheTelemetryOperation operation, long durationInNanos, @Nullable Object valueFromCache) {
        Key key = new Key(operation.cacheName(), operation.origin(), operation.name(), STATUS_SUCCESS);
        Timer timer = this.durations.computeIfAbsent(key, k -> {
            Timer.Builder builder = Timer.builder((String)METRIC_CACHE_DURATION).tag(TAG_CACHE_NAME, k.cacheName()).tag(TAG_OPERATION, k.operationName()).tag(TAG_ORIGIN, k.origin()).tag(TAG_STATUS, k.status());
            return builder.register(this.meterRegistry);
        });
        timer.record(durationInNanos, TimeUnit.NANOSECONDS);
        if ("GET".startsWith(operation.name())) {
            Counter counter;
            String ratioType;
            Collection vc;
            OpKey operationKey = new OpKey(operation.cacheName(), operation.origin());
            if (valueFromCache == null || valueFromCache instanceof Collection && !(vc = (Collection)valueFromCache).isEmpty()) {
                ratioType = TYPE_MISS;
                counter = this.missCounters.computeIfAbsent(operationKey, k -> {
                    Counter.Builder builder = Counter.builder((String)METRIC_CACHE_MISS).description("!!! DEPRECATED !!! Please use cache.ratio metric").tag(TAG_CACHE_NAME, k.cacheName()).tag(TAG_ORIGIN, k.origin());
                    return builder.register(this.meterRegistry);
                });
                counter.increment();
            } else {
                ratioType = TYPE_HIT;
                counter = this.hitCounters.computeIfAbsent(operationKey, k -> {
                    Counter.Builder builder = Counter.builder((String)METRIC_CACHE_HIT).description("!!! DEPRECATED !!! Please use cache.ratio metric").tag(TAG_CACHE_NAME, k.cacheName()).tag(TAG_ORIGIN, k.origin());
                    return builder.register(this.meterRegistry);
                });
                counter.increment();
            }
            RatioKey ratioKey = new RatioKey(operation.cacheName(), operation.origin(), ratioType);
            counter = this.counters.computeIfAbsent(ratioKey, k -> {
                Counter.Builder builder = Counter.builder((String)METRIC_CACHE_RATIO).tag(TAG_CACHE_NAME, k.cacheName()).tag(TAG_ORIGIN, k.origin()).tag(TAG_TYPE, ratioType);
                return builder.register(this.meterRegistry);
            });
            counter.increment();
        }
    }

    public void recordFailure(@Nonnull CacheTelemetryOperation operation, long durationInNanos, @Nullable Throwable throwable) {
        Key key = new Key(operation.cacheName(), operation.origin(), operation.name(), STATUS_FAILED);
        Timer timer = this.durations.computeIfAbsent(key, k -> {
            Timer.Builder builder = Timer.builder((String)METRIC_CACHE_DURATION).tag(TAG_CACHE_NAME, k.cacheName()).tag(TAG_OPERATION, k.operationName()).tag(TAG_ORIGIN, k.origin()).tag(TAG_STATUS, k.status());
            return builder.register(this.meterRegistry);
        });
        timer.record(durationInNanos, TimeUnit.NANOSECONDS);
    }

    record Key(String cacheName, String origin, String operationName, String status) {
    }

    record OpKey(String cacheName, String origin) {
    }

    record RatioKey(String cacheName, String origin, String type) {
    }
}

