/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.camunda.zeebe.worker;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetrics;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.camunda.zeebe.worker.Micrometer120ZeebeWorkerMetrics;
import ru.tinkoff.kora.micrometer.module.camunda.zeebe.worker.Micrometer123ZeebeWorkerMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerZeebeWorkerMetricsFactory
implements ZeebeWorkerMetricsFactory {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerZeebeWorkerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public ZeebeWorkerMetrics get(TelemetryConfig.MetricsConfig config) {
        if (Objects.requireNonNullElse(config.enabled(), true).booleanValue()) {
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Micrometer120ZeebeWorkerMetrics(this.meterRegistry, config);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Micrometer123ZeebeWorkerMetrics(this.meterRegistry, config);
            };
        }
        return null;
    }
}

