/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.db;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.database.common.telemetry.DataBaseMetricWriter;
import ru.tinkoff.kora.database.common.telemetry.DataBaseMetricWriterFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.db.Opentelemetry120DataBaseMetricWriter;
import ru.tinkoff.kora.micrometer.module.db.Opentelemetry123DataBaseMetricWriter;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerDataBaseMetricWriterFactory
implements DataBaseMetricWriterFactory {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerDataBaseMetricWriterFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public DataBaseMetricWriter get(TelemetryConfig.MetricsConfig metrics, String poolName) {
        if (Objects.requireNonNullElse(metrics.enabled(), true).booleanValue()) {
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120DataBaseMetricWriter(this.meterRegistry, metrics, poolName);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123DataBaseMetricWriter(this.meterRegistry, metrics, poolName);
            };
        }
        return null;
    }
}

