/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.client;

import io.grpc.ServiceDescriptor;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.net.URI;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetrics;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.grpc.client.Opentelemetry120GrpcClientMetrics;
import ru.tinkoff.kora.micrometer.module.grpc.client.Opentelemetry123GrpcClientMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerGrpcClientMetricsFactory
implements GrpcClientMetricsFactory {
    private final MeterRegistry registry;
    private final MetricsConfig metricsConfig;

    public MicrometerGrpcClientMetricsFactory(MeterRegistry registry, MetricsConfig metricsConfig) {
        this.registry = registry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public GrpcClientMetrics get(ServiceDescriptor service, TelemetryConfig.MetricsConfig config, URI uri) {
        if (config.enabled() != null && !config.enabled().booleanValue()) {
            return null;
        }
        return switch (this.metricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120GrpcClientMetrics(this.registry, service, config, uri);
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123GrpcClientMetrics(this.registry, service, config, uri);
        };
    }
}

