/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.client;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry120GrpcClientMetrics
implements GrpcClientMetrics {
    private final ConcurrentHashMap<MetricsKey, Metrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry registry;
    private final ServiceDescriptor service;
    private final TelemetryConfig.MetricsConfig config;
    private final URI uri;
    private static final AtomicIntegerFieldUpdater<Opentelemetry120GrpcClientMetrics> REQUESTS_PER_PRC = AtomicIntegerFieldUpdater.newUpdater(Opentelemetry120GrpcClientMetrics.class, "requestsPerRpc");
    private volatile int requestsPerRpc = 0;
    private static final AtomicIntegerFieldUpdater<Opentelemetry120GrpcClientMetrics> RESPONSES_PER_RPC = AtomicIntegerFieldUpdater.newUpdater(Opentelemetry120GrpcClientMetrics.class, "responsesPerRpc");
    private volatile int responsesPerRpc = 0;

    public Opentelemetry120GrpcClientMetrics(MeterRegistry registry, ServiceDescriptor service, TelemetryConfig.MetricsConfig config, URI uri) {
        this.registry = registry;
        this.service = service;
        this.config = config;
        this.uri = uri;
    }

    public <RespT, ReqT> void recordEnd(MethodDescriptor<ReqT, RespT> method, long startTime, Exception e) {
        MetricsKey key = new MetricsKey(this.service.getName(), method.getBareMethodName(), null, e.getClass());
        Metrics metrics = this.metrics.computeIfAbsent(key, this::buildMetrics);
        double processingTime = (double)(System.nanoTime() - startTime) / 1000000.0;
        metrics.duration.record(processingTime);
    }

    private Metrics buildMetrics(MetricsKey method) {
        List<Tag> tags = this.tags(method);
        DistributionSummary duration = DistributionSummary.builder((String)"rpc.client.duration").tags(tags).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).register(this.registry);
        DistributionSummary requestsByRpc = DistributionSummary.builder((String)"rpc.client.requests_per_rpc").tags(tags).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).register(this.registry);
        DistributionSummary responsesByRpc = DistributionSummary.builder((String)"rpc.client.responses_per_rpc").tags(tags).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).register(this.registry);
        return new Metrics(duration, requestsByRpc, responsesByRpc);
    }

    private List<Tag> tags(MetricsKey key) {
        String rpcService = Objects.requireNonNullElse(key.serviceName(), "GrpcService");
        String serverAddress = this.uri.getHost();
        int serverPort = this.uri.getPort();
        if (serverPort == -1) {
            serverPort = 80;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(7);
        list.add(Tag.of((String)SemanticAttributes.RPC_METHOD.getKey(), (String)key.bareMethodName()));
        list.add(Tag.of((String)SemanticAttributes.RPC_SERVICE.getKey(), (String)rpcService));
        list.add(Tag.of((String)SemanticAttributes.RPC_SYSTEM.getKey(), (String)"grpc"));
        list.add(Tag.of((String)SemanticAttributes.SERVER_ADDRESS.getKey(), (String)serverAddress));
        list.add(Tag.of((String)SemanticAttributes.SERVER_PORT.getKey(), (String)String.valueOf(serverPort)));
        if (key.code != null) {
            list.add(Tag.of((String)SemanticAttributes.RPC_GRPC_STATUS_CODE.getKey(), (String)String.valueOf(key.code)));
        } else {
            list.add(Tag.of((String)SemanticAttributes.RPC_GRPC_STATUS_CODE.getKey(), (String)""));
        }
        if (key.errorType != null) {
            list.add(Tag.of((String)SemanticAttributes.ERROR_TYPE.getKey(), (String)key.errorType.getCanonicalName()));
        } else {
            list.add(Tag.of((String)SemanticAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        return list;
    }

    public <RespT, ReqT> void recordEnd(MethodDescriptor<ReqT, RespT> method, long startTime, Status status, Metadata trailers) {
        Integer code = status == null ? null : Integer.valueOf(status.getCode().value());
        MetricsKey key = new MetricsKey(this.service.getName(), method.getBareMethodName(), code, null);
        Metrics metrics = this.metrics.computeIfAbsent(key, this::buildMetrics);
        double processingTime = (double)(System.nanoTime() - startTime) / 1000000.0;
        metrics.duration.record(processingTime);
        metrics.requestsByRpc.record((double)this.requestsPerRpc);
        metrics.responsesByRpc.record((double)this.responsesPerRpc);
    }

    public <RespT, ReqT> void recordSendMessage(MethodDescriptor<ReqT, RespT> method, ReqT message) {
        REQUESTS_PER_PRC.incrementAndGet(this);
    }

    public <RespT, ReqT> void recordReceiveMessage(MethodDescriptor<ReqT, RespT> method, RespT message) {
        RESPONSES_PER_RPC.incrementAndGet(this);
    }

    record MetricsKey(String serviceName, String bareMethodName, @Nullable Integer code, @Nullable Class<? extends Throwable> errorType) {
    }

    record Metrics(DistributionSummary duration, DistributionSummary requestsByRpc, DistributionSummary responsesByRpc) {
    }
}

