/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.server;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetrics;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.grpc.server.Opentelemetry120GrpcServerMetrics;
import ru.tinkoff.kora.micrometer.module.grpc.server.Opentelemetry123GrpcServerMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerGrpcServerMetricsFactory
implements GrpcServerMetricsFactory {
    private final ConcurrentHashMap<MetricsKey, GrpcServerMetrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerGrpcServerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    public GrpcServerMetrics get(TelemetryConfig.MetricsConfig config, ServerCall<?, ?> call, Metadata headers, String serviceName, String methodName) {
        return this.metrics.computeIfAbsent(new MetricsKey(serviceName, methodName), key -> this.buildMetrics(config, (MetricsKey)key));
    }

    private GrpcServerMetrics buildMetrics(TelemetryConfig.MetricsConfig config, MetricsKey metricsKey) {
        Function<Integer, DistributionSummary> duration = code -> {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)"rpc.server.duration").serviceLevelObjectives(config.slo(this.metricsConfig.opentelemetrySpec()));
            return builder.baseUnit(switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> "milliseconds";
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> "s";
            }).tag(SemanticAttributes.RPC_SYSTEM.getKey(), "grpc").tag(SemanticAttributes.RPC_SERVICE.getKey(), metricsKey.serviceName).tag(SemanticAttributes.RPC_METHOD.getKey(), metricsKey.methodName).tag(SemanticAttributes.RPC_GRPC_STATUS_CODE.getKey(), Integer.toString(code)).register(this.meterRegistry);
        };
        Counter requestsPerRpc = Counter.builder((String)"rpc.server.requests_per_rpc").baseUnit("messages").tag(SemanticAttributes.RPC_SYSTEM.getKey(), "grpc").tag(SemanticAttributes.RPC_SERVICE.getKey(), metricsKey.serviceName).tag(SemanticAttributes.RPC_METHOD.getKey(), metricsKey.methodName).register(this.meterRegistry);
        Counter responsesPerRpc = Counter.builder((String)"rpc.server.responses_per_rpc").baseUnit("messages").tag(SemanticAttributes.RPC_SYSTEM.getKey(), "grpc").tag(SemanticAttributes.RPC_SERVICE.getKey(), metricsKey.serviceName).tag(SemanticAttributes.RPC_METHOD.getKey(), metricsKey.methodName).register(this.meterRegistry);
        return switch (this.metricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120GrpcServerMetrics(duration, requestsPerRpc, responsesPerRpc);
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123GrpcServerMetrics(duration, requestsPerRpc, responsesPerRpc);
        };
    }

    private record MetricsKey(String serviceName, String methodName) {
    }
}

