/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.server;

import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetrics;

public final class Opentelemetry123GrpcServerMetrics
implements GrpcServerMetrics {
    private final Map<Integer, DistributionSummary> duration = new ConcurrentHashMap<Integer, DistributionSummary>();
    private final Function<Integer, DistributionSummary> durationFactory;
    private final Counter requestsPerRpc;
    private final Counter responsesPerRpc;

    public Opentelemetry123GrpcServerMetrics(Function<Integer, DistributionSummary> durationFactory, Counter requestsPerRpc, Counter responsesPerRpc) {
        this.durationFactory = durationFactory;
        this.requestsPerRpc = requestsPerRpc;
        this.responsesPerRpc = responsesPerRpc;
    }

    public void onClose(Status status, Throwable exception, long processingTimeNano) {
        double durationValue = (double)processingTimeNano / 1.0E9;
        Status finalStatus = Objects.requireNonNullElse(status, Status.UNKNOWN);
        this.duration.computeIfAbsent(finalStatus.getCode().value(), this.durationFactory).record(durationValue);
    }

    public void onSend(Object message) {
        this.responsesPerRpc.increment();
    }

    public void onReceive(Object message) {
        this.requestsPerRpc.increment();
    }
}

