/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.http.server;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerMetrics;
import ru.tinkoff.kora.micrometer.module.http.server.tag.ActiveRequestsKey;
import ru.tinkoff.kora.micrometer.module.http.server.tag.DurationKey;
import ru.tinkoff.kora.micrometer.module.http.server.tag.MicrometerHttpServerTagsProvider;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry123HttpServerMetrics
implements HttpServerMetrics {
    private final MeterRegistry meterRegistry;
    private final MicrometerHttpServerTagsProvider httpServerTagsProvider;
    private final ConcurrentHashMap<ActiveRequestsKey, AtomicInteger> requestCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<DurationKey, DistributionSummary> duration = new ConcurrentHashMap();
    private final TelemetryConfig.MetricsConfig config;

    public Opentelemetry123HttpServerMetrics(MeterRegistry meterRegistry, MicrometerHttpServerTagsProvider httpServerTagsProvider, @Nullable TelemetryConfig.MetricsConfig config) {
        this.meterRegistry = meterRegistry;
        this.httpServerTagsProvider = httpServerTagsProvider;
        this.config = config;
    }

    public void requestStarted(String method, String pathTemplate, String host, String scheme) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new ActiveRequestsKey(method, pathTemplate, host, scheme), activeRequestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((ActiveRequestsKey)activeRequestsKey, c);
            return c;
        });
        counter.incrementAndGet();
    }

    public void requestFinished(int statusCode, HttpResultCode resultCode, String scheme, String host, String method, String pathTemplate, HttpHeaders headers, long processingTimeNanos, Throwable exception) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new ActiveRequestsKey(method, pathTemplate, host, scheme), activeRequestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((ActiveRequestsKey)activeRequestsKey, c);
            return c;
        });
        counter.decrementAndGet();
        DurationKey key = new DurationKey(statusCode, method, pathTemplate, host, scheme, exception == null ? null : exception.getClass());
        this.duration.computeIfAbsent(key, this::requestDuration).record((double)processingTimeNanos / 1.0E9);
    }

    private void registerActiveRequestsGauge(ActiveRequestsKey key, AtomicInteger counter) {
        Gauge.builder((String)"http.server.active_requests", (Object)counter, AtomicInteger::get).tags(this.httpServerTagsProvider.getActiveRequestsTags(key)).register(this.meterRegistry);
    }

    private DistributionSummary requestDuration(DurationKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"http.server.request.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tags(this.httpServerTagsProvider.getDurationTags(key));
        return builder.register(this.meterRegistry);
    }
}

