/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.producer;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.kafka.producer.Opentelemetry120KafkaProducerMetrics;
import ru.tinkoff.kora.micrometer.module.kafka.producer.Opentelemetry123KafkaProducerMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class MicrometerKafkaProducerMetricsFactory
implements KafkaProducerMetricsFactory {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerKafkaProducerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public KafkaProducerMetrics get(TelemetryConfig.MetricsConfig metrics, Producer<?, ?> producer, Properties properties) {
        if (Objects.requireNonNullElse(metrics.enabled(), true).booleanValue()) {
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120KafkaProducerMetrics(this.meterRegistry, metrics, producer, properties);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123KafkaProducerMetrics(this.meterRegistry, metrics, producer, properties);
            };
        }
        return null;
    }
}

