/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.producer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class Opentelemetry120KafkaProducerMetrics
implements KafkaProducerMetrics,
AutoCloseable {
    private final KafkaClientMetrics micrometerMetrics;
    private final Properties properties;
    private final TelemetryConfig.MetricsConfig config;
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<TopicPartition, DistributionSummary> metrics = new ConcurrentHashMap();

    public Opentelemetry120KafkaProducerMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, Producer<?, ?> producer, Properties properties) {
        this.micrometerMetrics = new KafkaClientMetrics(producer);
        this.micrometerMetrics.bindTo(meterRegistry);
        this.properties = properties;
        this.config = config;
        this.meterRegistry = meterRegistry;
    }

    public KafkaProducerMetrics.KafkaProducerTxMetrics tx() {
        return new KafkaProducerMetrics.KafkaProducerTxMetrics(){

            public void commit() {
            }

            public void rollback(@Nullable Throwable e) {
            }
        };
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, Throwable e) {
        DistributionSummary m = this.metrics.computeIfAbsent(new TopicPartition(record.topic(), Objects.requireNonNullElse(record.partition(), -1).intValue()), this::metrics);
        m.record((double)durationNanos / 1000000.0);
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, RecordMetadata metadata) {
        DistributionSummary m = this.metrics.computeIfAbsent(new TopicPartition(metadata.topic(), metadata.partition()), this::metrics);
        m.record((double)durationNanos / 1000000.0);
    }

    @Override
    public void close() throws Exception {
        this.micrometerMetrics.close();
        Iterator<Map.Entry<TopicPartition, DistributionSummary>> i = this.metrics.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<TopicPartition, DistributionSummary> entry = i.next();
            i.remove();
            try {
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private DistributionSummary metrics(TopicPartition topicPartition) {
        Object clientId = this.properties.get("client.id");
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"messaging.publish.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tag(SemanticAttributes.MESSAGING_SYSTEM.getKey(), "kafka").tag(SemanticAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), Integer.toString(topicPartition.partition())).tag(SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey(), topicPartition.topic()).tag(SemanticAttributes.MESSAGING_CLIENT_ID.getKey(), Objects.requireNonNullElse(clientId, "").toString());
        return builder.register(this.meterRegistry);
    }
}

