/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.producer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class Opentelemetry123KafkaProducerMetrics
implements KafkaProducerMetrics,
AutoCloseable {
    private final KafkaClientMetrics micrometerMetrics;
    private final Properties properties;
    private final TelemetryConfig.MetricsConfig config;
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<DurationKey, DistributionSummary> metrics = new ConcurrentHashMap();

    public Opentelemetry123KafkaProducerMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, Producer<?, ?> producer, Properties properties) {
        this.micrometerMetrics = new KafkaClientMetrics(producer);
        this.micrometerMetrics.bindTo(meterRegistry);
        this.properties = properties;
        this.config = config;
        this.meterRegistry = meterRegistry;
    }

    public KafkaProducerMetrics.KafkaProducerTxMetrics tx() {
        return new KafkaProducerMetrics.KafkaProducerTxMetrics(){

            public void commit() {
            }

            public void rollback(@Nullable Throwable e) {
            }
        };
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, Throwable e) {
        DurationKey key = new DurationKey(record.topic(), Objects.requireNonNullElse(record.partition(), -1), e.getClass());
        DistributionSummary m = this.metrics.computeIfAbsent(key, this::metrics);
        m.record((double)durationNanos / 1.0E9);
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, RecordMetadata metadata) {
        DurationKey key = new DurationKey(record.topic(), Objects.requireNonNullElse(record.partition(), -1), null);
        DistributionSummary m = this.metrics.computeIfAbsent(key, this::metrics);
        m.record((double)durationNanos / 1.0E9);
    }

    @Override
    public void close() {
        this.micrometerMetrics.close();
        Iterator<Map.Entry<DurationKey, DistributionSummary>> i = this.metrics.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<DurationKey, DistributionSummary> entry = i.next();
            i.remove();
            try {
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private DistributionSummary metrics(DurationKey key) {
        Object clientId = this.properties.get("client.id");
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"messaging.publish.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tag(SemanticAttributes.MESSAGING_SYSTEM.getKey(), "kafka").tag(SemanticAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), Integer.toString(key.partition())).tag(SemanticAttributes.MESSAGING_DESTINATION_NAME.getKey(), key.topic()).tag(SemanticAttributes.MESSAGING_CLIENT_ID.getKey(), Objects.requireNonNullElse(clientId, "").toString());
        Class<? extends Throwable> errorType = key.errorType();
        if (errorType != null) {
            builder.tag(SemanticAttributes.ERROR_TYPE.getKey(), errorType.getCanonicalName());
        } else {
            builder.tag(SemanticAttributes.ERROR_TYPE.getKey(), "");
        }
        return builder.register(this.meterRegistry);
    }

    private record DurationKey(String topic, int partition, @Nullable Class<? extends Throwable> errorType) {
    }
}

