/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.resilient;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerMetrics;

public final class MicrometerCircuitBreakerMetrics
implements CircuitBreakerMetrics {
    private final Map<String, StateMetrics> metrics = new ConcurrentHashMap<String, StateMetrics>();
    private final MeterRegistry registry;

    public MicrometerCircuitBreakerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void recordState(@Nonnull String name, @Nonnull CircuitBreaker.State newState) {
        StateMetrics stateMetrics = this.metrics.computeIfAbsent(name, k -> {
            AtomicInteger gaugeState = new AtomicInteger(this.asIntState(newState));
            Gauge state = Gauge.builder((String)"resilient.circuitbreaker.state", gaugeState::get).tag("name", name).description("Circuit Breaker state metrics, where 0 -> CLOSED, 1 -> HALF_OPEN, 2 -> OPEN").register(this.registry);
            Counter transOpen = Counter.builder((String)"resilient.circuitbreaker.transition").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.OPEN.name()).register(this.registry);
            Counter transHalfOpen = Counter.builder((String)"resilient.circuitbreaker.transition").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.HALF_OPEN.name()).register(this.registry);
            return new StateMetrics(gaugeState, state, transOpen, transHalfOpen);
        });
        stateMetrics.stateValue().set(this.asIntState(newState));
        if (newState == CircuitBreaker.State.OPEN) {
            stateMetrics.transitionOpen().increment();
        } else if (newState == CircuitBreaker.State.HALF_OPEN) {
            stateMetrics.transitionHalfOpen().increment();
        }
    }

    private int asIntState(CircuitBreaker.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case CircuitBreaker.State.CLOSED -> 0;
            case CircuitBreaker.State.HALF_OPEN -> 1;
            case CircuitBreaker.State.OPEN -> 2;
        };
    }

    private record StateMetrics(AtomicInteger stateValue, Gauge state, Counter transitionOpen, Counter transitionHalfOpen) {
    }
}

