/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.resilient;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.resilient.timeout.TimeoutMetrics;

public final class MicrometerTimeoutMetrics
implements TimeoutMetrics {
    private final ConcurrentHashMap<String, Metrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry registry;

    public MicrometerTimeoutMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void recordTimeout(@Nonnull String name, long timeoutInNanos) {
        Metrics metrics = this.metrics.computeIfAbsent(name, k -> this.build(name));
        metrics.exhausted().increment();
    }

    private Metrics build(String name) {
        Counter exhausted = Counter.builder((String)"resilient.timeout.exhausted").baseUnit("operations").tag("name", name).register(this.registry);
        return new Metrics(exhausted);
    }

    private record Metrics(Counter exhausted) {
    }
}

