/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.s3.client;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.s3.client.S3Exception;
import ru.tinkoff.kora.s3.client.telemetry.S3ClientMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class Opentelemetry123S3ClientMetrics
implements S3ClientMetrics {
    private static final AttributeKey<String> ERROR_CODE = AttributeKey.stringKey((String)"aws.error.code");
    private static final AttributeKey<String> CLIENT_NAME = AttributeKey.stringKey((String)"aws.client.name");
    private final ConcurrentHashMap<DurationKey, DistributionSummary> duration = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final TelemetryConfig.MetricsConfig config;
    private final Class<?> client;

    public Opentelemetry123S3ClientMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, Class<?> client) {
        this.meterRegistry = meterRegistry;
        this.config = config;
        this.client = client;
    }

    public void record(String method, String bucket, @Nullable String key, int statusCode, long processingTimeNanos, @Nullable S3Exception exception) {
        String errorCode = exception != null ? exception.getErrorCode() : null;
        this.duration.computeIfAbsent(new DurationKey(method, bucket, statusCode, errorCode), this::duration).record((double)processingTimeNanos / 1.0E9);
    }

    private DistributionSummary duration(DurationKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"s3.client.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tag(CLIENT_NAME.getKey(), this.client.getSimpleName()).tag(SemanticAttributes.AWS_S3_BUCKET.getKey(), key.bucket()).tag(SemanticAttributes.HTTP_REQUEST_METHOD.getKey(), key.method()).tag(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), Integer.toString(key.statusCode())).tag(ERROR_CODE.getKey(), Objects.requireNonNullElse(key.errorCode(), ""));
        return builder.register(this.meterRegistry);
    }

    private record DurationKey(String method, String bucket, int statusCode, @Nullable String errorCode) {
    }
}

