/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.soap.client;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.soap.client.Opentelemetry120SoapClientMetrics;
import ru.tinkoff.kora.micrometer.module.soap.client.Opentelemetry123SoapClientMetrics;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetrics;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetricsFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class MicrometerSoapClientMetricsFactory
implements SoapClientMetricsFactory {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerSoapClientMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public SoapClientMetrics get(TelemetryConfig.MetricsConfig config, String serviceClass, String serviceName, String soapMethod, String url) {
        if (Objects.requireNonNullElse(config.enabled(), true).booleanValue()) {
            int n;
            URI uri = URI.create(url);
            String host = uri.getHost();
            String scheme = uri.getScheme();
            if (uri.getPort() != -1) {
                n = uri.getPort();
            } else {
                switch (scheme) {
                    case "http": {
                        n = 80;
                        break;
                    }
                    case "https": {
                        n = 443;
                        break;
                    }
                    default: {
                        n = -1;
                    }
                }
            }
            int port = n;
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120SoapClientMetrics(this.meterRegistry, config, serviceName, soapMethod, host, port);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123SoapClientMetrics(this.meterRegistry, config, serviceName, soapMethod, host, port);
            };
        }
        return null;
    }
}

