/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistrar;
import io.opentelemetry.contrib.metrics.micrometer.MicrometerMeterProvider;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.client.common.HttpClientConfig;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.PrometheusMeterRegistryInitializer;
import ru.tinkoff.kora.micrometer.module.PrometheusMeterRegistryWrapper;
import ru.tinkoff.kora.micrometer.module.cache.MicrometerCacheMetrics;
import ru.tinkoff.kora.micrometer.module.cache.caffeine.MicrometerCaffeineCacheMetricCollector;
import ru.tinkoff.kora.micrometer.module.cache.redis.lettuce.MicrometerLettuceCommandLatencyRecorderFactory;
import ru.tinkoff.kora.micrometer.module.camunda.engine.bpmn.MicrometerCamundaEngineBpmnMetricsFactory;
import ru.tinkoff.kora.micrometer.module.camunda.rest.MicrometerCamundaRestMetricsFactory;
import ru.tinkoff.kora.micrometer.module.camunda.zeebe.job.MicrometerZeebeClientWorkerJobMetricsFactory;
import ru.tinkoff.kora.micrometer.module.camunda.zeebe.worker.MicrometerZeebeWorkerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.db.MicrometerDataBaseMetricWriterFactory;
import ru.tinkoff.kora.micrometer.module.grpc.client.MicrometerGrpcClientMetricsFactory;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.DefaultMicrometerGrpcClientTagsProvider;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MicrometerGrpcClientTagsProvider;
import ru.tinkoff.kora.micrometer.module.grpc.server.MicrometerGrpcServerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.grpc.server.tag.DefaultMicrometerGrpcServerTagsProvider;
import ru.tinkoff.kora.micrometer.module.grpc.server.tag.MicrometerGrpcServerTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.client.MicrometerHttpClientMetricsFactory;
import ru.tinkoff.kora.micrometer.module.http.client.tag.MicrometerHttpClientTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.client.tag.Opentelemetry120MicrometerHttpClientTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.client.tag.Opentelemetry123MicrometerHttpClientTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.server.MicrometerHttpServerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.http.server.MicrometerPrivateApiMetrics;
import ru.tinkoff.kora.micrometer.module.http.server.tag.DefaultMicrometerHttpServerTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.server.tag.MicrometerHttpServerTagsProvider;
import ru.tinkoff.kora.micrometer.module.http.server.tag.Opentelemetry123MicrometerHttpServerTagsProvider;
import ru.tinkoff.kora.micrometer.module.jms.consumer.MicrometerJmsConsumerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.MicrometerKafkaConsumerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.MicrometerKafkaConsumerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.Opentelemetry120KafkaConsumerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.Opentelemetry123KafkaConsumerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.producer.MicrometerKafkaProducerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.MicrometerKafkaProducerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.Opentelemetry120KafkaProviderTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.Opentelemetry123KafkaProviderTagsProvider;
import ru.tinkoff.kora.micrometer.module.resilient.MicrometerCircuitBreakerMetrics;
import ru.tinkoff.kora.micrometer.module.resilient.MicrometerFallbackMetrics;
import ru.tinkoff.kora.micrometer.module.resilient.MicrometerRetryMetrics;
import ru.tinkoff.kora.micrometer.module.resilient.MicrometerTimeoutMetrics;
import ru.tinkoff.kora.micrometer.module.s3.client.MicrometerS3ClientMetricsFactory;
import ru.tinkoff.kora.micrometer.module.s3.client.MicrometerS3KoraClientMetricsFactory;
import ru.tinkoff.kora.micrometer.module.scheduling.MicrometerSchedulingMetricsFactory;
import ru.tinkoff.kora.micrometer.module.soap.client.MicrometerSoapClientMetricsFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public interface MetricsModule {
    default public MetricsConfig globalMetricsConfig(Config config, ConfigValueExtractor<MetricsConfig> extractor) {
        ConfigValue configValue = config.get("metrics");
        return Optional.ofNullable((MetricsConfig)extractor.extract(configValue)).orElseThrow(() -> ConfigValueExtractionException.missingValueAfterParse((ConfigValue)configValue));
    }

    @Root
    default public PrometheusMeterRegistryWrapper prometheusMeterRegistry(All<PrometheusMeterRegistryInitializer> initializers) {
        return new PrometheusMeterRegistryWrapper((List<PrometheusMeterRegistryInitializer>)initializers);
    }

    @DefaultComponent
    default public MicrometerHttpServerTagsProvider micrometerHttpServerTagsProvider(HttpServerConfig config, MetricsConfig globalMetricsConfig) {
        return switch (globalMetricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new DefaultMicrometerHttpServerTagsProvider();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123MicrometerHttpServerTagsProvider();
        };
    }

    @DefaultComponent
    default public MicrometerHttpServerMetricsFactory micrometerHttpServerMetricsFactory(MeterRegistry meterRegistry, MicrometerHttpServerTagsProvider httpServerTagsProvider, MetricsConfig metricsConfig) {
        return new MicrometerHttpServerMetricsFactory(meterRegistry, httpServerTagsProvider, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerHttpClientTagsProvider micrometerHttpClientTagsProvider(HttpClientConfig httpClientConfig, MetricsConfig globalMetricsConfig) {
        return switch (globalMetricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120MicrometerHttpClientTagsProvider();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123MicrometerHttpClientTagsProvider();
        };
    }

    @DefaultComponent
    default public MicrometerHttpClientMetricsFactory micrometerHttpClientMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig, MicrometerHttpClientTagsProvider tagsProvider) {
        return new MicrometerHttpClientMetricsFactory(meterRegistry, metricsConfig, tagsProvider);
    }

    @DefaultComponent
    default public MicrometerSoapClientMetricsFactory micrometerSoapClientMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerSoapClientMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerPrivateApiMetrics micrometerPrivateApiMetrics(PrometheusMeterRegistry meterRegistry) {
        return new MicrometerPrivateApiMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerGrpcServerTagsProvider micrometerGrpcServerTagsProvider(MetricsConfig globalMetricsConfig) {
        return new DefaultMicrometerGrpcServerTagsProvider();
    }

    @DefaultComponent
    default public MicrometerGrpcServerMetricsFactory micrometerGrpcServerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig, MicrometerGrpcServerTagsProvider grpcServerTagsProvider) {
        return new MicrometerGrpcServerMetricsFactory(meterRegistry, metricsConfig, grpcServerTagsProvider);
    }

    @DefaultComponent
    default public MicrometerGrpcClientTagsProvider micrometerGrpcClientTagsProvider() {
        return new DefaultMicrometerGrpcClientTagsProvider();
    }

    @DefaultComponent
    default public MicrometerGrpcClientMetricsFactory micrometerGrpcClientMetricsFactory(MeterRegistry registry, MetricsConfig metricsConfig, MicrometerGrpcClientTagsProvider tagsProvider) {
        return new MicrometerGrpcClientMetricsFactory(registry, metricsConfig, tagsProvider);
    }

    @DefaultComponent
    default public MicrometerDataBaseMetricWriterFactory micrometerDataBaseMetricWriterFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerDataBaseMetricWriterFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerKafkaConsumerTagsProvider micrometerKafkaConsumerTagsProvider(MetricsConfig globalMetricsConfig) {
        return switch (globalMetricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120KafkaConsumerTagsProvider();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123KafkaConsumerTagsProvider();
        };
    }

    @DefaultComponent
    default public MicrometerKafkaConsumerMetricsFactory micrometerKafkaConsumerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig, MicrometerKafkaConsumerTagsProvider tagsProvider) {
        return new MicrometerKafkaConsumerMetricsFactory(meterRegistry, metricsConfig, tagsProvider);
    }

    @DefaultComponent
    default public MicrometerKafkaProducerTagsProvider micrometerKafkaProducerTagsProvider(MetricsConfig globalMetricsConfig) {
        return switch (globalMetricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120KafkaProviderTagsProvider();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123KafkaProviderTagsProvider();
        };
    }

    @DefaultComponent
    default public MicrometerKafkaProducerMetricsFactory micrometerKafkaProducerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig, MicrometerKafkaProducerTagsProvider tagsProvider) {
        return new MicrometerKafkaProducerMetricsFactory(meterRegistry, metricsConfig, tagsProvider);
    }

    @DefaultComponent
    default public MicrometerJmsConsumerMetricsFactory micrometerJmsConsumerMetricsFactory(MeterRegistry meterRegistry) {
        return new MicrometerJmsConsumerMetricsFactory(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerSchedulingMetricsFactory micrometerSchedulingMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerSchedulingMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerCircuitBreakerMetrics micrometerCircuitBreakerMetrics(MeterRegistry meterRegistry) {
        return new MicrometerCircuitBreakerMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerFallbackMetrics micrometerFallbackMetrics(MeterRegistry meterRegistry) {
        return new MicrometerFallbackMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerRetryMetrics micrometerRetryMetrics(MeterRegistry meterRegistry) {
        return new MicrometerRetryMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerTimeoutMetrics micrometerTimeoutMetrics(MeterRegistry meterRegistry) {
        return new MicrometerTimeoutMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerCacheMetrics micrometerCacheMetrics(MeterRegistry meterRegistry) {
        return new MicrometerCacheMetrics(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerCaffeineCacheMetricCollector micrometerCaffeineCacheMetricsCollector(MeterRegistry meterRegistry) {
        return new MicrometerCaffeineCacheMetricCollector(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerS3ClientMetricsFactory micrometerS3ClientMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerS3ClientMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerS3KoraClientMetricsFactory micrometerS3KoraClientMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerS3KoraClientMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerCamundaEngineBpmnMetricsFactory micrometerCamundaEngineBpmnMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerCamundaEngineBpmnMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerCamundaRestMetricsFactory micrometerCamundaRestMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerCamundaRestMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerZeebeWorkerMetricsFactory micrometerZeebeWorkerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        return new MicrometerZeebeWorkerMetricsFactory(meterRegistry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerZeebeClientWorkerJobMetricsFactory micrometerZeebeClientWorkerJobMetricsFactory(MeterRegistry meterRegistry) {
        return new MicrometerZeebeClientWorkerJobMetricsFactory(meterRegistry);
    }

    @DefaultComponent
    default public MicrometerLettuceCommandLatencyRecorderFactory micrometerLettuceCommandLatencyRecorderFactory(MeterRegistry registry, MetricsConfig metricsConfig) {
        return new MicrometerLettuceCommandLatencyRecorderFactory(registry, metricsConfig);
    }

    @DefaultComponent
    default public MicrometerMeterProvider micrometerMeterProvider(MeterRegistry registry, @Nullable CallbackRegistrar callbackRegistrar) {
        return MicrometerMeterProvider.builder((MeterRegistry)registry).setCallbackRegistrar(callbackRegistrar).build();
    }
}

