/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.micrometer.module.PrometheusMeterRegistryInitializer;

public final class PrometheusMeterRegistryWrapper
implements Lifecycle,
Wrapped<PrometheusMeterRegistry> {
    private static final String KORA_VERSION = PrometheusMeterRegistryWrapper.readVersion();
    private final List<PrometheusMeterRegistryInitializer> initializers;
    private volatile PrometheusMeterRegistry registry;
    private volatile JvmGcMetrics gcMetrics;
    private volatile Gauge koraVersionMetric;

    public PrometheusMeterRegistryWrapper(List<PrometheusMeterRegistryInitializer> initializers) {
        this.initializers = initializers;
    }

    public void init() {
        PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        for (PrometheusMeterRegistryInitializer initializer : this.initializers) {
            meterRegistry = (PrometheusMeterRegistry)initializer.apply(meterRegistry);
        }
        this.gcMetrics = new JvmGcMetrics();
        new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        this.gcMetrics.bindTo((MeterRegistry)meterRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)meterRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)meterRegistry);
        this.registry = meterRegistry;
        Metrics.addRegistry((MeterRegistry)this.registry);
        this.koraVersionMetric = Gauge.builder((String)"kora.up", (Object)1, i -> i.intValue()).tag("version", KORA_VERSION).register((MeterRegistry)this.registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PrometheusMeterRegistry r = this.registry;
        JvmGcMetrics gcMetrics = this.gcMetrics;
        Gauge koraVersion = this.koraVersionMetric;
        try {
            if (gcMetrics != null) {
                gcMetrics.close();
            }
        }
        finally {
            try {
                if (koraVersion != null) {
                    koraVersion.close();
                }
            }
            finally {
                if (r != null) {
                    this.registry = null;
                    Metrics.removeRegistry((MeterRegistry)r);
                    r.close();
                }
            }
        }
    }

    public PrometheusMeterRegistry value() {
        return this.registry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersion() {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/kora/version/common");){
            if (is == null) {
                String string2 = "UNKNOWN";
                return string2;
            }
            byte[] bytes = is.readAllBytes();
            String string = new String(bytes, StandardCharsets.US_ASCII);
            return string;
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }
}

