/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.cache.redis.lettuce;

import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import ru.tinkoff.kora.cache.redis.lettuce.telemetry.CommandLatencyRecorderFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.cache.redis.lettuce.Opentelemetry120LettuceCommandLatencyRecorder;
import ru.tinkoff.kora.micrometer.module.cache.redis.lettuce.Opentelemetry123LettuceCommandLatencyRecorder;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerLettuceCommandLatencyRecorderFactory
implements CommandLatencyRecorderFactory {
    private final MeterRegistry registry;
    private final MetricsConfig metricsConfig;

    public MicrometerLettuceCommandLatencyRecorderFactory(MeterRegistry registry, MetricsConfig metricsConfig) {
        this.registry = registry;
        this.metricsConfig = metricsConfig;
    }

    public CommandLatencyRecorder get(String type, TelemetryConfig.MetricsConfig config) {
        if (config.enabled() != null && !config.enabled().booleanValue()) {
            return CommandLatencyRecorder.disabled();
        }
        return switch (this.metricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120LettuceCommandLatencyRecorder(type, this.registry, config);
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123LettuceCommandLatencyRecorder(type, this.registry, config);
        };
    }
}

