/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.camunda.engine.bpmn;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.ErrorAttributes;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Micrometer120CamundaEngineBpmnMetrics
implements CamundaEngineBpmnMetrics {
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<RequestKey, AtomicInteger> requestCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Key, DistributionSummary> duration = new ConcurrentHashMap();
    private final TelemetryConfig.MetricsConfig config;

    public Micrometer120CamundaEngineBpmnMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config) {
        this.meterRegistry = meterRegistry;
        this.config = config;
    }

    public void executionStarted(String javaDelegateName, DelegateExecution execution) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new RequestKey(javaDelegateName, execution.getProcessBusinessKey()), requestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((RequestKey)requestsKey, c);
            return c;
        });
        counter.incrementAndGet();
    }

    public void executionFinished(String javaDelegateName, DelegateExecution execution, long processingTimeNano, @Nullable Throwable exception) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new RequestKey(javaDelegateName, execution.getProcessBusinessKey()), requestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((RequestKey)requestsKey, c);
            return c;
        });
        counter.decrementAndGet();
        Class<?> errorType = exception != null ? exception.getClass() : null;
        Key key = new Key(javaDelegateName, execution.getProcessBusinessKey(), errorType);
        this.duration.computeIfAbsent(key, this::requestDuration).record((double)processingTimeNano / 1000000.0);
    }

    private void registerActiveRequestsGauge(RequestKey key, AtomicInteger counter) {
        ArrayList<Tag> list = new ArrayList<Tag>(2);
        list.add(Tag.of((String)"delegate", (String)key.javaDelegateName()));
        list.add(Tag.of((String)"business.key", (String)key.businessKey()));
        Gauge.builder((String)"camunda.engine.delegate.active_requests", (Object)counter, AtomicInteger::get).tags(list).register(this.meterRegistry);
    }

    private DistributionSummary requestDuration(Key key) {
        ArrayList<Tag> list = new ArrayList<Tag>(3);
        if (key.errorType() != null) {
            list.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            list.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        list.add(Tag.of((String)"delegate", (String)key.javaDelegateName()));
        list.add(Tag.of((String)"business.key", (String)key.businessKey()));
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"camunda.engine.delegate.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tags(list);
        return builder.register(this.meterRegistry);
    }

    record RequestKey(String javaDelegateName, String businessKey) {
    }

    record Key(String javaDelegateName, String businessKey, @Nullable Class<? extends Throwable> errorType) {
    }
}

