/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.camunda.rest;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.incubating.HttpIncubatingAttributes;
import jakarta.annotation.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetrics;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Micrometer120CamundaRestMetrics
implements CamundaRestMetrics {
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<ActiveRequestsKey, AtomicInteger> requestCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<DurationKey, DistributionSummary> duration = new ConcurrentHashMap();
    private final TelemetryConfig.MetricsConfig config;

    public Micrometer120CamundaRestMetrics(MeterRegistry meterRegistry, @Nullable TelemetryConfig.MetricsConfig config) {
        this.meterRegistry = meterRegistry;
        this.config = config;
    }

    public void requestStarted(String method, String pathTemplate, String host, String scheme) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new ActiveRequestsKey(method, pathTemplate, host, scheme), activeRequestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((ActiveRequestsKey)activeRequestsKey, c);
            return c;
        });
        counter.incrementAndGet();
    }

    public void requestFinished(int statusCode, HttpResultCode resultCode, String scheme, String host, String method, String pathTemplate, HttpHeaders headers, long processingTimeNanos, Throwable exception) {
        AtomicInteger counter = this.requestCounters.computeIfAbsent(new ActiveRequestsKey(method, pathTemplate, host, scheme), activeRequestsKey -> {
            AtomicInteger c = new AtomicInteger(0);
            this.registerActiveRequestsGauge((ActiveRequestsKey)activeRequestsKey, c);
            return c;
        });
        counter.decrementAndGet();
        Class<?> errorType = exception != null ? exception.getClass() : null;
        DurationKey key = new DurationKey(statusCode, method, pathTemplate, host, scheme, errorType);
        this.duration.computeIfAbsent(key, this::requestDuration).record((double)processingTimeNanos / 1000000.0);
    }

    private void registerActiveRequestsGauge(ActiveRequestsKey key, AtomicInteger counter) {
        Gauge.builder((String)"camunda.rest.server.active_requests", (Object)counter, AtomicInteger::get).tags(new String[]{HttpAttributes.HTTP_ROUTE.getKey(), key.target()}).tags(new String[]{HttpAttributes.HTTP_REQUEST_METHOD.getKey(), key.method()}).tags(new String[]{ServerAttributes.SERVER_ADDRESS.getKey(), key.host()}).tags(new String[]{UrlAttributes.URL_SCHEME.getKey(), key.scheme()}).tags(new String[]{HttpIncubatingAttributes.HTTP_TARGET.getKey(), key.target()}).tags(new String[]{HttpIncubatingAttributes.HTTP_METHOD.getKey(), key.method()}).register(this.meterRegistry);
    }

    private DistributionSummary requestDuration(DurationKey key) {
        return DistributionSummary.builder((String)"camunda.rest.server.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tags(new String[]{HttpAttributes.HTTP_REQUEST_METHOD.getKey(), key.method()}).tags(new String[]{HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), Integer.toString(key.statusCode())}).tags(new String[]{HttpAttributes.HTTP_ROUTE.getKey(), key.route()}).tags(new String[]{ServerAttributes.SERVER_ADDRESS.getKey(), key.host()}).tags(new String[]{UrlAttributes.URL_SCHEME.getKey(), key.scheme()}).tags(new String[]{HttpIncubatingAttributes.HTTP_TARGET.getKey(), key.route()}).tags(new String[]{HttpIncubatingAttributes.HTTP_METHOD.getKey(), key.method()}).tags(new String[]{HttpIncubatingAttributes.HTTP_STATUS_CODE.getKey(), Integer.toString(key.statusCode())}).register(this.meterRegistry);
    }

    private record ActiveRequestsKey(String method, String target, String host, String scheme) {
    }

    private record DurationKey(int statusCode, String method, String route, String host, String scheme, @Nullable Class<? extends Throwable> errorType) {
    }
}

