/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.camunda.rest;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetrics;
import ru.tinkoff.kora.camunda.rest.telemetry.CamundaRestMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.camunda.rest.Micrometer120CamundaRestMetrics;
import ru.tinkoff.kora.micrometer.module.camunda.rest.Micrometer123CamundaRestMetrics;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerCamundaRestMetricsFactory
implements CamundaRestMetricsFactory {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;

    public MicrometerCamundaRestMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
    }

    @Nullable
    public CamundaRestMetrics get(TelemetryConfig.MetricsConfig config) {
        if (Objects.requireNonNullElse(config.enabled(), true).booleanValue()) {
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Micrometer120CamundaRestMetrics(this.meterRegistry, config);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Micrometer123CamundaRestMetrics(this.meterRegistry, config);
            };
        }
        return null;
    }
}

