/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.camunda.zeebe.worker;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.camunda.zeebe.worker.JobContext;
import ru.tinkoff.kora.camunda.zeebe.worker.JobWorkerException;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerMetrics;
import ru.tinkoff.kora.camunda.zeebe.worker.telemetry.ZeebeWorkerTelemetry;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Micrometer123ZeebeWorkerMetrics
implements ZeebeWorkerMetrics {
    private static final String CODE_UNKNOWN = "UNKNOWN";
    private static final String STATUS_COMPLETE = "complete";
    private static final String STATUS_FAILED = "failed";
    private static final String ERROR_USER = "user";
    private static final String ERROR_SYSTEM = "system";
    private final ConcurrentHashMap<MetricsKey, Metrics> keyToMetrics = new ConcurrentHashMap();
    private final MeterRegistry registry;
    private final TelemetryConfig.MetricsConfig config;

    public Micrometer123ZeebeWorkerMetrics(MeterRegistry registry, TelemetryConfig.MetricsConfig config) {
        this.registry = registry;
        this.config = config;
    }

    public void recordComplete(JobContext jobContext, long startTimeInNanos) {
        MetricsKey key = new MetricsKey(jobContext.jobName(), jobContext.jobType());
        Metrics metrics = this.keyToMetrics.computeIfAbsent(key, k -> this.buildMetrics(jobContext));
        double processingTime = (double)(System.nanoTime() - startTimeInNanos) / 1.0E9;
        metrics.complete.record(processingTime);
    }

    public void recordFailed(JobContext jobContext, long startTimeInNanos, ZeebeWorkerTelemetry.ErrorType errorType, Throwable throwable) {
        String string;
        MetricsKey key = new MetricsKey(jobContext.jobName(), jobContext.jobType());
        Metrics metrics = this.keyToMetrics.computeIfAbsent(key, k -> this.buildMetrics(jobContext));
        double processingTime = (double)(System.nanoTime() - startTimeInNanos) / 1.0E9;
        if (ZeebeWorkerTelemetry.ErrorType.USER.equals((Object)errorType)) {
            metrics.failedUser.record(processingTime);
        } else {
            metrics.failedSystem.record(processingTime);
        }
        if (throwable instanceof JobWorkerException) {
            JobWorkerException je = (JobWorkerException)throwable;
            string = je.getCode();
        } else {
            string = CODE_UNKNOWN;
        }
        String errorCode = string;
        Counter errorCodeCounter = metrics.codeToCounter.computeIfAbsent(errorCode, k -> Counter.builder((String)"zeebe.worker.handler").tags(List.of(Tag.of((String)"job.name", (String)jobContext.jobName()), Tag.of((String)"job.type", (String)jobContext.jobType()), Tag.of((String)"status", (String)STATUS_FAILED), Tag.of((String)"error.code", (String)errorCode))).register(this.registry));
        errorCodeCounter.increment();
    }

    private Metrics buildMetrics(JobContext jobContext) {
        DistributionSummary durationSuccess = DistributionSummary.builder((String)"zeebe.worker.handler.duration").tags(List.of(Tag.of((String)"job.name", (String)jobContext.jobName()), Tag.of((String)"job.type", (String)jobContext.jobType()), Tag.of((String)"status", (String)STATUS_COMPLETE))).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").register(this.registry);
        DistributionSummary durationFailedUser = DistributionSummary.builder((String)"zeebe.worker.handler.duration").tags(List.of(Tag.of((String)"job.name", (String)jobContext.jobName()), Tag.of((String)"job.type", (String)jobContext.jobType()), Tag.of((String)"status", (String)STATUS_FAILED), Tag.of((String)"error", (String)ERROR_USER))).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").register(this.registry);
        DistributionSummary durationFailedSystem = DistributionSummary.builder((String)"zeebe.worker.handler.duration").tags(List.of(Tag.of((String)"job.name", (String)jobContext.jobName()), Tag.of((String)"job.type", (String)jobContext.jobType()), Tag.of((String)"status", (String)STATUS_FAILED), Tag.of((String)"error", (String)ERROR_SYSTEM))).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").register(this.registry);
        return new Metrics(durationSuccess, durationFailedUser, durationFailedSystem, new ConcurrentHashMap<String, Counter>());
    }

    record MetricsKey(String jobName, String jobType) {
    }

    record Metrics(DistributionSummary complete, DistributionSummary failedUser, DistributionSummary failedSystem, Map<String, Counter> codeToCounter) {
    }
}

